/***************************************************************************
                            KListBox.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Extends the functionality of {@link QListBox} to honor the system
 wide settings for Single Click/Double Click mode, Auto Selection and
 Change Cursor over Link.

 There is a new signal {@link #executed}. It gets connected to either
 {@link QListBox#clicked} or {@link QListBox#doubleClicked}
 depending on the KDE wide Single Click/Double Click settings. It is
 strongly recomended that you use this signal instead of the above
 mentioned. This way you dont need to care about the current
 settings.  If you want to get informed when the user selects
 something connect to the {@link QListBox#selectionChanged} signal.

 @short A variant of @ref QListBox that honors KDE's system-wide settings.

*/
public class KListBox extends QListBox  {
	protected KListBox(Class dummy){super((Class) null);}

	private native void newKListBox( QWidget parent, String name, int f);
	public KListBox( QWidget parent, String name, int f) {
		super((Class) null);
		newKListBox( parent, name, f);
	}
	private native void newKListBox();
	public KListBox() {
		super((Class) null);
		newKListBox();
	}
	protected native void emitExecute( QListBoxItem item, QPoint pos);
	protected native void slotOnItem( QListBoxItem item);
	protected native void slotOnViewport();
	protected native void slotSettingsChanged( int arg1);

/** 
 Auto selection happend.
   
*/
	protected native void slotAutoSelect();
}

/** Override these methods in subclasses of KListBox to customise event handling behaviour */
interface KListBoxEventHandling {

/** 

   
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);

/** 

   
*/
	void focusOutEvent(QFocusEvent fe);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);

/** 

   
*/
	void leaveEvent(QEvent e);
	void showEvent(QShowEvent arg1);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void contentsDropEvent(QDropEvent arg1);
	void focusInEvent(QFocusEvent e);
	void contentsDragLeaveEvent(QDragLeaveEvent arg1);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);

/** 

   
*/
	void contentsMouseDoubleClickEvent(QMouseEvent e);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void contentsMouseReleaseEvent(QMouseEvent arg1);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent arg1);
	void contentsMouseMoveEvent(QMouseEvent arg1);

/** 

   
*/
	void contentsMousePressEvent(QMouseEvent e);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

