/***************************************************************************
                            KPalette.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Class for handling Palettes.

 This class makes it easy to handle palettes.
 A palette is a set of colors. This class can read
 and write palettes from and to a file.

 This class uses the "GIMP" palette file format.

 This class is totally unrelated to QPalette.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: KPalette.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short 
 Class for handling Palettes.
*/
public class  KPalette implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KPalette(Class dummy){}


/** 
 KPalette constructor. Creates a KPalette from a file
 the filename is derived from the name.

*/
	private native void newKPalette( String name);
	public KPalette( String name) {
		newKPalette( name);
	}
	private native void newKPalette();
	public KPalette() {
		newKPalette();
	}

/** 
 KPalette copy constructor.

*/
	private native void newKPalette( KPalette arg1);
	public KPalette( KPalette arg1) {
		newKPalette( arg1);
	}

/** 
 KPalette destructor.

*/
	protected native void finalize() throws InternalError;

/** 
 Save the palette

*/
	public native boolean save();

/** 
 Get the description of the palette.

*/
	public native String description();

/**    	
 Set the description of the palette.

*/
	public native void setDescription( String desc);

/** 
 Get the name of the palette. 

*/
	public native String name();

/** 
 Set the name of the palette.

*/
	public native void setName( String name);

/** 
 Returns whether the palette may be edited.

*/
	public native int editable();

/** 
 Change whether the palette may be editted.

*/
	public native void setEditable( int editable);

/** 
 Return the number of colors in the palette.

*/
	public native int nrColors();

/** 
 Find color by index.

*/
	public native QColor color( int index);

/** 
 Find index by <code>color.</code>

*/
	public native int findColor( QColor color);

/**  
 Find colorname by <code>index.</code>

*/
	public native String colorName( int index);

/** 
 Find colorname by <code>color.</code>

*/
	public native String colorName( QColor color);

/** 
 Add a color.

*/
	public native int addColor( QColor newColor, String newColorName);
	public native int addColor( QColor newColor);

/** 
 Change a color.

*/
	public native int changeColor( int index, QColor newColor, String newColorName);
	public native int changeColor( int index, QColor newColor);

/** 
 Change a color.

*/
	public native int changeColor( QColor oldColor, QColor newColor, String newColorName);
	public native int changeColor( QColor oldColor, QColor newColor);

/** 
 Query which KDE palettes are installed.

*/
	public static native ArrayList getPaletteList();
	public static final int Yes = 0;
	public static final int No = 1;
	public static final int Ask = 2;
}
