/***************************************************************************
                            KPasswordDialog.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This dialog asks the user to enter a password. The functions you're 
 probably interested in are the static methods, {@link #getPassword} and
 {@link #getNewPassword}.

 <pre>
 QCString password;
 int result = KPasswordDialog.getPassword(password, i18n("Password"));
 if (result == KPasswordDialog.Accepted)
     use(password);
 </pre>

 Keeping passwords in memory can be a potential security hole. You should
 handle this situation with care.

 @author Geert Jansen <jansen@kde.org>
 
 @short A password input dialog.

*/
public class KPasswordDialog extends KDialogBase  {
	protected KPasswordDialog(Class dummy){super((Class) null);}

	private native void newKPasswordDialog( int type, String prompt, boolean enableKeep, int extraBttn);
	public KPasswordDialog( int type, String prompt, boolean enableKeep, int extraBttn) {
		super((Class) null);
		newKPasswordDialog( type, prompt, enableKeep, extraBttn);
	}
	private native void newKPasswordDialog( int type, String prompt);
	public KPasswordDialog( int type, String prompt) {
		super((Class) null);
		newKPasswordDialog( type, prompt);
	}
	protected native void finalize() throws InternalError;

/**  Set the password prompt. 
*/
	public native void setPrompt( String prompt);

/**  Add a line of information to the dialog. 
*/
	public native void addLine( String key, String value);

/**  
 Returns the password entered. The memory is freed in the destructor,
 so you should make a copy.
     
*/
	public native String password();

/**  Returns true if the user wants to keep the password. 
*/
	public native boolean keep();

/** 
 Pops up the dialog, asks the user for a password, and returns it.

*/
	public static native int getPassword( String password, String prompt, int[] keep);
	public static native int getPassword( String password, String prompt);

/**  
 Pops up the dialog, asks the user for a password and returns it. The
 user has to enter the password twice to make sure it was entered
 correctly.

*/
	public static native int getNewPassword( String password, String prompt);

/**  Static helper funtion that disables core dumps. 
*/
	public static native void disableCoreDumps();

/**  Virtual function that can be overridden to provide password
 checking in derived classes. It should return <code>true</code> if the
 password is valid, <code>false</code> otherwise. 
*/
	protected native boolean checkPassword( String arg1);
	protected native void slotOk();
	protected native void slotCancel();
	protected native void slotKeep( boolean arg1);
	public static final int Password = 0;
	public static final int NewPassword = 1;
}

/** Override these methods in subclasses of KPasswordDialog to customise event handling behaviour */
interface KPasswordDialogEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

