/***************************************************************************
                            KPopupFrame.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Frame with popup menu behaviour.

 @author Tim Gilman, Mirko Boehm

 @version $Id: KPopupFrame.java,v 1.3 2001/05/16 22:52:51 rdale Exp $

 @short 
 Frame with popup menu behaviour.
*/
public class KPopupFrame extends QFrame  {
	protected KPopupFrame(Class dummy){super((Class) null);}


/**  The contructor. Creates a dialog without buttons. 
*/
	private native void newKPopupFrame( QWidget parent, String name);
	public KPopupFrame( QWidget parent, String name) {
		super((Class) null);
		newKPopupFrame( parent, name);
	}
	private native void newKPopupFrame();
	public KPopupFrame() {
		super((Class) null);
		newKPopupFrame();
	}

/**  Set the main widget. You cannot set the main widget from the constructor,
      since it must be a child of the frame itselfes.
      Be careful: the size is set to the main widgets size. It is up to you to
      set the main widgets correct size before setting it as the main
      widget. 
*/
	public native void setMainWidget( QWidget m);

/**  The resize event. Simply resizes the main widget to the whole
      widgets client size. 
*/
	public native void resizeEvent( QResizeEvent arg1);

/**  Open the popup window at position pos. 
*/
	public native void popup( QPoint pos);

/**  Execute the popup window. 
*/
	public native int exec( QPoint p);

/**  Dito. 
*/
	public native int exec( int x, int y);

/**  Close the popup window. This is called from the main widget, usually.
      r is the result returned from exec(). 
*/
	public native void close( int r);
}

/** Override these methods in subclasses of KPopupFrame to customise event handling behaviour */
interface KPopupFrameEventHandling {

/**  Catch key press events. 
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

