/***************************************************************************
                            KPopupTitle.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Title widget for use in {@link KPopupMenu}.

 You usually don't have to create this manually since
 {@link KPopupMenu#insertTitle} will do it for you, but it is allowed if
 you wish to customize it's look.

 @author Daniel M. Duley <mosfet@kde.org>

 @short KPopupMenu title widget.
 
*/
public class KPopupTitle extends QWidget  {
	protected KPopupTitle(Class dummy){super((Class) null);}


/** 
 Create a title widget with the user specified gradient, pixmap,
 and colors.
     
*/
	private native void newKPopupTitle( QWidget parent, String name);
	public KPopupTitle( QWidget parent, String name) {
		super((Class) null);
		newKPopupTitle( parent, name);
	}
	private native void newKPopupTitle();
	public KPopupTitle() {
		super((Class) null);
		newKPopupTitle();
	}

/** 
 Create a title widget with the specified gradient and colors.
     
*/
	private native void newKPopupTitle( int gradient, QColor color, QColor textColor, QWidget parent, String name);
	public KPopupTitle( int gradient, QColor color, QColor textColor, QWidget parent, String name) {
		super((Class) null);
		newKPopupTitle( gradient, color, textColor, parent, name);
	}
	private native void newKPopupTitle( int gradient, QColor color, QColor textColor);
	public KPopupTitle( int gradient, QColor color, QColor textColor) {
		super((Class) null);
		newKPopupTitle( gradient, color, textColor);
	}

/** 
 Create a title widget with the specified pixmap and colors.
     
*/
	private native void newKPopupTitle( KPixmap background, QColor color, QColor textColor, QWidget parent, String name);
	public KPopupTitle( KPixmap background, QColor color, QColor textColor, QWidget parent, String name) {
		super((Class) null);
		newKPopupTitle( background, color, textColor, parent, name);
	}
	private native void newKPopupTitle( KPixmap background, QColor color, QColor textColor);
	public KPopupTitle( KPixmap background, QColor color, QColor textColor) {
		super((Class) null);
		newKPopupTitle( background, color, textColor);
	}

/** 
 Set the title string and optional icon for the title widget.

 You will
 want to call this before inserting into a menu.
     
*/
	public native void setTitle( String text, QPixmap icon);
	public native void setTitle( String text);

/** 
 Retrieve the current title.
     
*/
	public native String title();

/** 
 Retrieve the current icon.
     
*/
	public native QPixmap icon();
	public native QSize sizeHint();
}

/** Override these methods in subclasses of KPopupTitle to customise event handling behaviour */
interface KPopupTitleEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent ev);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

