/***************************************************************************
                            KShred.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Erase a file in a way that makes recovery impossible -- well, no guarentee
 of that, but at least as difficult as reasonably possible.
 For this, KShred write several times over the
 existing file, using different patterns, before deleting it.

 @author David Faure <faure@kde.org> (integration into KDE and progress signal)
 
 @short 
 Erase a file in a way that makes recovery impossible -- well, no guarentee
 of that, but at least as difficult as reasonably possible.
*/
public class KShred extends QObject  {
	protected KShred(Class dummy){super((Class) null);}


/** 
 Initialize the class using the name of the file to 'shred'.

*/
	private native void newKShred( String fileName);
	public KShred( String fileName) {
		super((Class) null);
		newKShred( fileName);
	}
	protected native void finalize() throws InternalError;

/** 
 Writes all 1's over the entire file and flushes the file buffers.

*/
	public native boolean fill1s();

/** 
 Writes all 0's over the entire file and flushes the file buffers.

*/
	public native boolean fill0s();

/** 
 Writes the specified byte over the entire file and flushes the file buffers.

*/
	public native boolean fillbyte( int arg1);

/** 
 Writes random bites over the entire file and flushes the file buffers.

*/
	public native boolean fillrandom();

/** 
 Writes the specified byte array over the entire file and flushes the file buffers.

*/
	public native boolean fillpattern( String pattern, int size);

/** 
 Shreds a file by writing a series of values over it (uses {@link fill0s}, then {@link fill1s}, then {@link fillrandom}, then {@link fillbyte}
 with 0101..., then {@link fillbyte} with 1010....

*/
	public native boolean shred();

/** 
 The simplest method to shred a file.
 No need to create an instance of the class.

*/
	public static native boolean shred( String fileName);
}

/** Override these methods in subclasses of KShred to customise event handling behaviour */
interface KShredEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

