/***************************************************************************
                            KSqueezedTextLabel.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A label class that squeezes its text into the label

 If the text is too long to fit into the label it is divided into
 remaining left and right parts which are separated by three dots.

 Example:
 http://www.kde.org/documentation/index.html could be squeezed to
 http://www.kde...ion/index.html

 
 @author Ronny Standtke <Ronny.Standtke@gmx.de>

 @version $Id: KSqueezedTextLabel.java,v 1.1 2001/05/07 01:30:47 rdale Exp $

 @short A replacement for QLabel that squeezes its text.
*/
public class KSqueezedTextLabel extends QLabel  {
	protected KSqueezedTextLabel(Class dummy){super((Class) null);}


/** 
 Default constructor.
   
*/
	private native void newKSqueezedTextLabel( QWidget parent);
	public KSqueezedTextLabel( QWidget parent) {
		super((Class) null);
		newKSqueezedTextLabel( parent);
	}
	private native void newKSqueezedTextLabel( QWidget parent, String name);
	public KSqueezedTextLabel( QWidget parent, String name) {
		super((Class) null);
		newKSqueezedTextLabel( parent, name);
	}
	private native void newKSqueezedTextLabel( String text, QWidget parent);
	public KSqueezedTextLabel( String text, QWidget parent) {
		super((Class) null);
		newKSqueezedTextLabel( text, parent);
	}
	private native void newKSqueezedTextLabel( String text, QWidget parent, String name);
	public KSqueezedTextLabel( String text, QWidget parent, String name) {
		super((Class) null);
		newKSqueezedTextLabel( text, parent, name);
	}
	public native void setText( String arg1);

/** 
 does the dirty work
   
*/
	protected native void squeezeTextToLabel();
}

/** Override these methods in subclasses of KSqueezedTextLabel to customise event handling behaviour */
interface KSqueezedTextLabelEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);

/** 
 used when widget is resized
   
*/
	void resizeEvent(QResizeEvent arg1);
}

