package DCOP::Object;

use strict;
use vars qw($VERSION $AUTOLOAD);

$VERSION = '0.01';

sub AUTOLOAD()
{
    my $funcname;
    ($funcname = $AUTOLOAD) =~ s/.*:://;
    return if $funcname eq 'DESTROY';
    my $self = shift;
    foreach my $func (map {DCOP::canonicalizeSignature $_}
                          @{DCOP::remoteFunctions($self->{CLIENT}, $self->{APP}, $self->{OBJ})})
    {
        next unless $func =~ /^$funcname\(/;
        unshift @_, $self->{CLIENT}, $self->{APP}, $self->{OBJ}, "$func";
        wantarray ? goto &DCOP::call : goto &DCOP::send;
    }
    die 'Function "', $self->{APP}, '.', $self->{OBJ}, ".$funcname()\" doesn't exist.";
}

sub _app()
{
    my $self = shift;
    $self->{APP};
}

sub _object()
{
    my $self = shift;
    $self->{OBJ};
}

1;
__END__

