/***************************************************************************
                            KSocket.cpp -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

#define _BOOL_H_
#include <ksock.h>
#include <qstring.h>
#include <qcstring.h>

#include <qtjava/QtSupport.h>
#include <kdejava/KSocket.h>

class KSocketJBridge : public KSocket
{
public:
	KSocketJBridge(int _sock) : KSocket(_sock) {}
	KSocketJBridge(const char* _host, unsigned short int _port, int timeOut) : KSocket(_host, _port, timeOut) {}
	KSocketJBridge(const char* _path) : KSocket(_path) {}
	~KSocketJBridge() {}
	bool  protected_connect(const QString& _host, unsigned short int _port) {
		return (bool ) KSocket::connect(_host, _port);
	}
	bool  protected_connect(const char* _path) {
		return (bool ) KSocket::connect(_path);
	}
	bool  protected_init_sockaddr(const QString& hostname, unsigned short int port) {
		return (bool ) KSocket::init_sockaddr(hostname, port);
	}
	void childEvent(QChildEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "childEvent", arg1, "org.kde.qt.QChildEvent")) {
			QObject::childEvent(arg1);
		}
		return;
	}
	void timerEvent(QTimerEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "timerEvent", arg1, "org.kde.qt.QTimerEvent")) {
			QObject::timerEvent(arg1);
		}
		return;
	}
};


JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__I(JNIEnv *env, jobject obj, jint _sock)
{
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((int) _sock));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__Ljava_lang_String_2SI(JNIEnv *env, jobject obj, jstring _host, jshort _port, jint timeOut)
{
static QCString * _qstring__host = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((char*) QtSupport::toCharString(env, _host, &_qstring__host), (unsigned short int) _port, (int) timeOut));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__Ljava_lang_String_2S(JNIEnv *env, jobject obj, jstring _host, jshort _port)
{
static QCString * _qstring__host = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((char*) QtSupport::toCharString(env, _host, &_qstring__host), (unsigned short int) _port, 30));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__Ljava_lang_String_2(JNIEnv *env, jobject obj, jstring _path)
{
static QCString * _qstring__path = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((char*) QtSupport::toCharString(env, _path, &_qstring__path)));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_finalize(JNIEnv *env, jobject obj)
{
	if (QtSupport::allocatedInJavaWorld(env, obj)) {
		delete (KSocket*)QtSupport::getQt(env, obj);
		QtSupport::setQt(env, obj, 0);
	}
	return;
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KSocket_socket(JNIEnv *env, jobject obj)
{
	return (jint) ((KSocketJBridge*) QtSupport::getQt(env, obj))->socket();
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_enableRead(JNIEnv *env, jobject obj, jboolean arg1)
{
	((KSocketJBridge*) QtSupport::getQt(env, obj))->enableRead((bool) arg1);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_enableWrite(JNIEnv *env, jobject obj, jboolean arg1)
{
	((KSocketJBridge*) QtSupport::getQt(env, obj))->enableWrite((bool) arg1);
	return;
}

JNIEXPORT jlong JNICALL
Java_org_kde_koala_KSocket_ipv4_1addr(JNIEnv *env, jobject obj)
{
	return (jlong) ((KSocketJBridge*) QtSupport::getQt(env, obj))->ipv4_addr();
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_slotWrite(JNIEnv *env, jobject obj, jint arg1)
{
	((KSocketJBridge*) QtSupport::getQt(env, obj))->slotWrite((int) arg1);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_slotRead(JNIEnv *env, jobject obj, jint arg1)
{
	((KSocketJBridge*) QtSupport::getQt(env, obj))->slotRead((int) arg1);
	return;
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_initSockaddr__ILjava_lang_String_2SI(JNIEnv *env, jclass obj, jint server_name, jstring hostname, jshort port, jint domain)
{
static QCString * _qstring_hostname = 0;
	return (jboolean) KSocketJBridge::initSockaddr((ksockaddr_in*) server_name, (char*) QtSupport::toCharString(env, hostname, &_qstring_hostname), (unsigned short int) port, (int) domain);
}

//JNIEXPORT jboolean JNICALL
//Java_org_kde_koala_KSocket_initSockaddr__ILjava_lang_String_2S(JNIEnv *env, jclass obj, jint server_name, jstring hostname, jshort port)
//{
//static QCString * _qstring_hostname = 0;
//	return (jboolean) KSocketJBridge::initSockaddr((ksockaddr_in*) server_name, (char*) QtSupport::toCharString(env, hostname, &_qstring_hostname), (unsigned short int) port, KSocket::PF_INET);
//}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_connect__Ljava_lang_String_2S(JNIEnv *env, jobject obj, jstring _host, jshort _port)
{
static QString * _qstring__host = 0;
	return (jboolean) ((KSocketJBridge*) QtSupport::getQt(env, obj))->protected_connect((QString&) * (QString *) QtSupport::toQString(env, _host, &_qstring__host), (unsigned short int) _port);
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_connect__Ljava_lang_String_2(JNIEnv *env, jobject obj, jstring _path)
{
static QCString * _qstring__path = 0;
	return (jboolean) ((KSocketJBridge*) QtSupport::getQt(env, obj))->protected_connect((char*) QtSupport::toCharString(env, _path, &_qstring__path));
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_init_1sockaddr(JNIEnv *env, jobject obj, jstring hostname, jshort port)
{
static QString * _qstring_hostname = 0;
	return (jboolean) ((KSocketJBridge*) QtSupport::getQt(env, obj))->protected_init_sockaddr((QString&) * (QString *) QtSupport::toQString(env, hostname, &_qstring_hostname), (unsigned short int) port);
}

