/***************************************************************************
                            BrowserExtension.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The following standard actions are defined by the host of the view :

 [selection-dependent actions]

 [normal actions]

 The view defines a slot with the name of the action in order to implement the action.
 The browser will detect the slot automatically and connect its action to it when
 appropriate (i.e. when the view is active).

 The selection-dependent actions are disabled by default and the view should
 enable them when the selection changes, emitting {@link #enableAction}.

 The normal actions do not depend on the selection.
 You need to enable 'print' when printing is possible - you can even do that
 in the constructor.

 A special case is the configuration slots, not connected to any action directly,
 and having parameters.

 [configuration slot]

 @short 
 The following standard actions are defined by the host of the view :

*/
public class BrowserExtension extends QObject  {
	protected BrowserExtension(Class dummy){super((Class) null);}


/** 
 Constructor

*/
	private native void newBrowserExtension( ReadOnlyPart parent, String name);
	public BrowserExtension( ReadOnlyPart parent, String name) {
		super((Class) null);
		newBrowserExtension( parent, name);
	}
	private native void newBrowserExtension( ReadOnlyPart parent);
	public BrowserExtension( ReadOnlyPart parent) {
		super((Class) null);
		newBrowserExtension( parent);
	}
	protected native void finalize() throws InternalError;
	public native void setURLArgs( URLArgs args);
	public native URLArgs urlArgs();

/** 
 Returns the current x offset.

 For a scrollview, implement this using contentsX().
   
*/
	public native int xOffset();

/** 
 Returns the current y offset.

 For a scrollview, implement this using contentsY().
   
*/
	public native int yOffset();

/** 
 Used by the browser to save the current state of the view
 (in order to restore it if going back in navigation).

 If you want to save additionnal properties, reimplement it
 but don't forget to call the parent method (probably first).
   
*/
	public native void saveState( QDataStream stream);

/** 
 Used by the browser to restore the view in the state
 it was when we left it.

 If you saved additionnal properties, reimplement it
 but don't forget to call the parent method (probably first).
   
*/
	public native void restoreState( QDataStream stream);

/** 
 Returns whether url drop handling is enabled.
 See {@link setURLDropHandlingEnabled} for more information about this
 property.
   
*/
	public native boolean isURLDropHandlingEnabled();

/** 
 Enables or disables url drop handling. URL drop handling is a property
 describing whether the hosting shell component is allowed to install an
 event filter on the part's widget, to listen for URI drop events.
 Set it to true if you are exporting a BrowserExtension implementation and
 do not provide any special URI drop handling. If set to false you can be
 sure to receive all those URI drop events unfiltered. Also note that the
 implementation as of Konqueror installs the even filter only on the part's
 widget itself, not on child widgets.
   
*/
	public native void setURLDropHandlingEnabled( boolean enable);
//	public native void setBrowserInterface( BrowserInterface* impl);
//	public native BrowserInterface* browserInterface();

/** 

*/
	public native boolean isActionEnabled( String name);

/** 
 Retrieve a map containing the action names as keys and corresponding
 SLOT()'ified method names as data entries.

 This is very useful for
 the host component, when connecting the own signals with the
 extension's slots.
 Basically you iterate over the map, check if the extension implements
 the slot and connect to the slot using the data value of your map
 iterator.
 Checking if the extension implements a certain slot can be done like this:

 <pre>
   extension.metaObject().slotNames().contains( actionName + "()" )
 </pre>

 (note that <code>actionName</code> is the iterator's key value if already
  iterating over the action slot map, returned by this method)

 Connecting to the slot can be done like this:

 <pre>
   connect( yourObject, SIGNAL(" yourSignal()"),
            extension, mapIterator.data() )
 </pre>

 (where "mapIterator" is your QMap<QCString,QCString> iterator)
   
*/
//	public static native ActionSlotMap actionSlotMap();

/** 

*/
//	public static native ActionSlotMap* actionSlotMapPtr();

/** 
 Queries <code>obj</code> for a child object which inherits from this
 BrowserExtension class. Convenience method.
   
*/
	public static native BrowserExtension childObject( QObject obj);
}

/** Override these methods in subclasses of BrowserExtension to customise event handling behaviour */
interface BrowserExtensionEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

