/***************************************************************************
                            DCOPRef.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.

 @author Torben Weis <weis@kde.org>
 
 @short 
 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.
*/
public class  DCOPRef implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected DCOPRef(Class dummy){}


/** 
 Create a null reference.
     
*/
	private native void newDCOPRef();
	public DCOPRef() {
		newDCOPRef();
	}

/** 
 Copy constructor.
     
*/
	private native void newDCOPRef( DCOPRef ref);
	public DCOPRef( DCOPRef ref) {
		newDCOPRef( ref);
	}

/** 
 Create a reference to a certain object in a
 certain application.

*/
	private native void newDCOPRef( String app, String obj);
	public DCOPRef( String app, String obj) {
		newDCOPRef( app, obj);
	}

/** 
 Create a reference to a certain object in a
 certain application.

*/
	private native void newDCOPRef( DCOPObjectInterface object);
	public DCOPRef( DCOPObjectInterface object) {
		newDCOPRef( object);
	}

/** 
 Create a reference to a certain object in a
 certain application.

*/
	private native void newDCOPRef( String app, String obj, String type);
	public DCOPRef( String app, String obj, String type) {
		newDCOPRef( app, obj, type);
	}

/** 
 Test wether it is a null reference.
     
*/
	public native boolean isNull();

/** 
 Name of the application in which the object resides.
     
*/
	public native String app();

/** 
 Object ID of the referenced object.
     
*/
	public native String object();

/** 
 type of the referenced object. May be null (i.e. unknown).
     
*/
	public native String type();

/** 
 Change the referenced object. Resets the type to unknown (null).
     
*/
	public native void setRef( String app, String obj);

/** 
 Change the referenced object
     
*/
	public native void setRef( String app, String obj, String type);

/** 
 Make it a null reference.
     
*/
	public native void clear();
}
