/***************************************************************************
                            DeviceManager.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 MIDI Device Manager class . This class is the one you should use to
 send MIDI events to any device, as it creates and manages the Out classes.

 This class is usually used by creating a DeviceManager object, then call
 {@link #openDev} and {@link #initDev} . Then, use {@link #numberOfMidiPorts},
 {@link #numberOfSynthDevices}, {@link #name} and {@link #type} to choose which
 device to play MIDI events to and then use {@link #defaultDevice} to set the
 MIDI device to play.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Manages all MIDI devices and redirects MIDI events to each one as
 configured.

*/
public class  DeviceManager implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected DeviceManager(Class dummy){}


/** 
 Constructor. It just initializes internal variables, before playing any
 music, you should call {@link #initManager}, {@link #setMidiMap}
 (optional), {@link #openDev}, {@link #initDev}, {@link #setPatchesToUse}
 (not required, unless you're playing to a GUS device, which must load
 the patches), {@link #tmrStart}, and finally, play the music.
     
*/
	private native void newDeviceManager( int def);
	public DeviceManager( int def) {
		newDeviceManager( def);
	}
	private native void newDeviceManager();
	public DeviceManager() {
		newDeviceManager();
	}

/** 
 Destructor. It closes the device (calling {@link #closeDev} ) if it wasn't
 closed before.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Initializes the MIDI Device Manager object.

 The /dev/sequencer and/or /dev/snd/seq files are opened, available
 devices are analyzed and Out objects are created. Then, the
 device files are closed.

*/
	public native int initManager();

/** 
 Checks if the device manager has been initialized (with @initManager),
 and in case it wasn't, initializes it.

*/
	public native int checkInit();

/** 
 Obsolete. Please use {@link #deviceForChannel} instead.

     
*/
	public native MidiOut chntodev( int chn);

/** 
 It's possible to send different MIDI channels to different MIDI devices,
 so that you can for example send channel 1 to an external synthesizer,
 channel 2 to a FM device and channel 10 to an AWE synth.

*/
	public native MidiOut deviceForChannel( int chn);

/** 
 Returns the device number associated with a given channel.
     
*/
	public native int deviceNumberForChannel( int chn);

/** 
 Sets the device number associated with a given channel.
     
*/
	public native void setDeviceNumberForChannel( int chn, int dev);

/** 

*/
	public native int ok();

/** 
 Returns true if it's running ALSA and false if OSS is being run
     
*/
	public native int usingAlsa();

/** 
 Open the devices. It first initializes the manager it that wasn't done
 yet (you should do it yourself, to be able to choose the MIDI output
 device, as it will be set to an external synth by default, if available).

 Then /dev/sequencer is opened and the MIDI devices are opened
 (calling {@link MidiOut#openDev} ).

*/
	public native void openDev();

/** 
 Closes the devices, and /dev/sequencer.

*/
	public native void closeDev();

/** 
 Calls {@link MidiOut#initDev} in turn in each of the available devices.

*/
	public native void initDev();

/** 
 Sends a Note On MIDI event.

*/
	public native void noteOn( String chn, String note, String vel);

/** 
 Sends a Note Off MIDI event. This is equivalent to send a Note On event
 with a vel value of 0.

*/
	public native void noteOff( String chn, String note, String vel);

/** 
 Sends a Key Pressure (or Aftertouch) MIDI event.
 This event changes the pressure over a key after this key has been played.

*/
	public native void keyPressure( String chn, String note, String vel);

/** 
 Changes the patch (instrument) on a MIDI channel.

*/
	public native void chnPatchChange( String chn, String patch);

/** 
 Changes the Pressure (Aftertouch) on a MIDI channel. Keep in mind that
 some synthesizers don't like this events, and it's better not to send it.

*/
	public native void chnPressure( String chn, String vel);

/** 
 Changes the Pitch Bender value on a MIDI channel. This bends the tone of
 each note played on this channel.

*/
	public native void chnPitchBender( String chn, String lsb, String msb);

/** 
 Sends a Controller event to a MIDI channel. This can be used for example
 to change the volume, set a XG patch, etc. Look for any General Midi
 resource page on the net for more information about the available
 controller events.

 For example, to set the tremolo value to a maximum on the MIDI channel
 number one, you should pass 1 to <code>chn</code>, 1 to <code>ctl</code> and 127 to <code>v.</code>

*/
	public native void chnController( String chn, String ctl, String v);

/** 
 Sends a SYStem EXclusive message to the default MIDI device (usually,
 external MIDI synths, as most internal synths do not support sysex
 messages)

*/
	public native void sysEx( String data, long size);

/** 
 Sets the number of milliseconds at which the next event will be sent.
 This way, you can schedule notes and events to send to the MIDI device.

*/
	public native void wait( double ms);

/** 
 Sets the tempo which will be used to convert between ticks and
 milliseconds.
     
*/
	public native void tmrSetTempo( int v);

/** 
 Starts the timer. You must call tmrStart before using {@link #wait}
     
*/
	public native void tmrStart( long tpcn);

/** 
 Stops the timer. This will be called by {@link #closeDev} before closing
 the device
     
*/
	public native void tmrStop();

/** 
 Continue the stopped timer . It is the same than starting a new timer, but
 without resetting it.
     
*/
	public native void tmrContinue();

/** 
 Sends an all notes off event
     
*/
	public native void allNotesOff();

/** 
 Synchronizes with the MIDI buffer. Midi events are put into a buffer,
 along with timer delays (see {@link #wait} ). sync returns when the buffer
 is empty.

*/
	public native void sync( boolean f);
	public native void sync();

/** 
 Changes the "master" volume of the played events by altering next volume
 controller events. The parameter <code>i</code> should be in the range of 0
 (nothing is heard) to 150 (music is played at a 150% of the original
 volume).

 Keep in mind that as most MIDI files already play music at near the
 maximum volume, an <code>i</code> value greater than 100 is very probably ignored
 most of the times.
     
*/
	public native void setVolumePercentage( int i);

/** 
 Returns the device to which the MIDI events will be sent.
 Returns -1 if there's no available device.

*/
	public native int defaultDevice();

/** 
 Sets the device to send the MIDI events to.

 By using {@link #midiPorts}, {@link #synthDevices}, {@link #name} and
 {@link #type}, you should choose which device to use (note that they are
 numbered with midi ports being first and synth devices next)

*/
	public native void setDefaultDevice( int i);

/** 
 Loads the patches you're going to use . This has effect only for GUS
 cards, although, if you use this function when {@link #defaultDevice} is
 not a GUS device, it will be ignored.

 The parameter is an int [256] array, which contain the following:

 The first 0..127 integers, are the number of times each General MIDI patch
 will be used, and -1 when the corresponding patch won't be used.

 The 128..255 integers are the number of times each drum voice (each note
 on the drum channel) will be used, and -1 when the corresponding
 percussion won't be used.

 This is done this way so that if the user has very little memory on his
 GUS card, and not all patches will be loaded, they are at least
 reordered, so that it first loads the one you're going to use most.

 In case you don't worry about such users, or you don't know "a priori"
 the number of notes you're going to play, you can just use 1 for each
 patch you want to load and -1 in the rest.

*/
	public native int setPatchesToUse( int[] patchesused);

/** 
 Returns the filename where the Midi Mapper was loaded from, or "" if no
 MIDI Mapper is in use.

*/
	public native String midiMapFilename();

/** 
 Sets a {@link MidiMapper} object to use. This object should already have
 loaded the configuration. See the description of {@link MidiMapper} for
 more information.

*/
	public native void setMidiMap( MidiMapper map);

/** 
 Returns the SNDCTL_SEQ_CTRLRATE ioctl value
     
*/
	public native int rate();

/** 
 Returns the number of MIDI ports available on the system. It's common that
 users have MIDI ports available, but there are no external synthesizers
 connected to these ports, so sending MIDI events to these ports will not
 produce any music in this case.

*/
	public native int midiPorts();

/** 
 Returns the number of internal synthesizers available on the system. Some
 of these devices will need special configuration, for example, to load
 sound patches.

*/
	public native int synthDevices();

/** 
 Returns the name of the <code>i</code>-th device . In case the DeviceManager wasn't
 yet initialized ( see {@link #checkInit} ), the return value is NULL, and
 in case the parameter has a value out of the valid range ( 0 to
 {@link #midiPorts} + {@link #synthDevices} ) it returns an empty string.
     
*/
	public native String name( int i);

/** 
 Returns the type of device the <code>i</code>-th device is , in a user-friendly
 string . For example, "External Midi Port" for midi ports, "FM" for FM
 synthesizers, "GUS" for Gravis Ultrasound devices, etc.
     
*/
	public native String type( int i);

/** 

     
*/
	protected native void seqbuf_dump();

/** 

     
*/
	protected native void seqbuf_clean();

/** 

     
*/
	protected native void checkAlsa();
}
