/***************************************************************************
                            Element.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 By far the vast majority of objects (apart from text) that authors
 encounter when traversing a document are <code> Element </code>
 nodes. Assume the following XML document: &lt;elementExample
 id=&quot;demo&quot;&gt; &lt;subelement1/&gt;
 &lt;subelement2&gt;&lt;subsubelement/&gt;&lt;/subelement2&gt;
 &lt;/elementExample&gt;

  When represented using DOM, the top node is an <code> Element
 </code> node for &quot;elementExample&quot;, which contains two
 child <code> Element </code> nodes, one for &quot;subelement1&quot;
 and one for &quot;subelement2&quot;. &quot;subelement1&quot;
 contains no child nodes.

  Elements may have attributes associated with them; since the
 <code> Element </code> interface inherits from <code> Node </code>
 , the generic <code> Node </code> interface method <code>
 getAttributes </code> may be used to retrieve the set of all
 attributes for an element. There are methods on the <code> Element
 </code> interface to retrieve either an <code> Attr </code> object
 by name or an attribute value by name. In XML, where an attribute
 value may contain entity references, an <code> Attr </code> object
 should be retrieved to examine the possibly fairly complex sub-tree
 representing the attribute value. On the other hand, in HTML, where
 all attributes have simple string values, methods to directly
 access an attribute value can safely be used as a convenience.

 
 @short 
 By far the vast majority of objects (apart from text) that authors
 encounter when traversing a document are <code> Element </code>
 nodes.
*/
public class Element extends DOMNode  {
	protected Element(Class dummy){super((Class) null);}

	private native void newElement();
	public Element() {
		super((Class) null);
		newElement();
	}
	private native void newElement( DOMNode other);
	public Element( DOMNode other) {
		super((Class) null);
		newElement( other);
	}
	private native void newElement( Element other);
	public Element( Element other) {
		super((Class) null);
		newElement( other);
	}
	protected native void finalize() throws InternalError;

/** 
 The name of the element. For example, in: &lt;elementExample
 id=&quot;demo&quot;&gt; ... &lt;/elementExample&gt; , <code>
 tagName </code> has the value <code> &quot;elementExample&quot;
 </code> . Note that this is case-preserving in XML, as are all
 of the operations of the DOM. The HTML DOM returns the <code>
 tagName </code> of an HTML element in the canonical uppercase
 form, regardless of the case in the source HTML document.

     
*/
	public native String tagName();

/** 
 Retrieves an attribute value by name.

     
*/
	public native String getAttribute( String name);

/** 
 Adds a new attribute. If an attribute with that name is already
 present in the element, its value is changed to be that of the
 value parameter. This value is a simple string, it is not
 parsed as it is being set. So any markup (such as syntax to be
 recognized as an entity reference) is treated as literal text,
 and needs to be appropriately escaped by the implementation
 when it is written out. In order to assign an attribute value
 that contains entity references, the user must create an <code>
 Attr </code> node plus any <code> Text </code> and <code>
 EntityReference </code> nodes, build the appropriate subtree,
 and use <code> setAttributeNode </code> to assign it as the
 value of an attribute.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
	public native void setAttribute( String name, String value);

/** 
 Removes an attribute by name. If the removed attribute has a
 default value it is immediately replaced.

     
*/
	public native void removeAttribute( String name);

/** 
 Retrieves an <code> Attr </code> node by name.

     
*/
	public native Attr getAttributeNode( String name);

/** 
 Adds a new attribute. If an attribute with that name is already
 present in the element, it is replaced by the new one.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

  INUSE_ATTRIBUTE_ERR: Raised if <code> newAttr </code> is
 already an attribute of another <code> Element </code> object.
 The DOM user must explicitly clone <code> Attr </code> nodes to
 re-use them in other elements.

     
*/
	public native Attr setAttributeNode( Attr newAttr);

/** 
 Removes the specified attribute.

  NOT_FOUND_ERR: Raised if <code> oldAttr </code> is not an
 attribute of the element.

     
*/
	public native Attr removeAttributeNode( Attr oldAttr);

/** 
 Returns a <code> NodeList </code> of all descendant elements
 with a given tag name, in the order in which they would be
 encountered in a preorder traversal of the <code> Element
 </code> tree.

     
*/
	public native ArrayList getElementsByTagName( String name);

/** 
 Puts all <code> Text </code> nodes in the full depth of the
 sub-tree underneath this <code> Element </code> into a "normal"
 form where only markup (e.g., tags, comments, processing
 instructions, CDATA sections, and entity references) separates
 <code> Text </code> nodes, i.e., there are no adjacent <code>
 Text </code> nodes. This can be used to ensure that the DOM
 view of a document is the same as if it were saved and
 re-loaded, and is useful when operations (such as XPointer
 lookups) that depend on a particular document tree structure
 are to be used.

     
*/
	public native void normalize();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentRange interface

 The style attribute
     
*/
	public native CSSStyleDeclaration style();

/** 

 not part of the DOM
     
*/
	public native boolean isHTMLElement();
//	private native void newElement( ElementImpl _impl);
//	public Element( ElementImpl _impl) {
//		super((Class) null);
//		newElement( _impl);
//	}
}
