/***************************************************************************
                            EntityReference.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 <code> EntityReference </code> objects may be inserted into the
 structure model when an entity reference is in the source document,
 or when the user wishes to insert an entity reference. Note that
 character references and references to predefined entities are
 considered to be expanded by the HTML or XML processor so that
 characters are represented by their Unicode equivalent rather than
 by an entity reference. Moreover, the XML processor may completely
 expand references to entities while building the structure model,
 instead of providing <code> EntityReference </code> objects. If it
 does provide such objects, then for a given <code> EntityReference
 </code> node, it may be that there is no <code> Entity </code> node
 representing the referenced entity; but if such an <code> Entity
 </code> exists, then the child list of the <code> EntityReference
 </code> node is the same as that of the <code> Entity </code> node.
 As with the <code> Entity </code> node, all descendants of the
 <code> EntityReference </code> are readonly.

  The resolution of the children of the <code> EntityReference
 </code> (the replacement value of the referenced <code> Entity
 </code> ) may be lazily evaluated; actions by the user (such as
 calling the <code> childNodes </code> method on the <code>
 EntityReference </code> node) are assumed to trigger the
 evaluation.

 
 @short 
 <code> EntityReference </code> objects may be inserted into the
 structure model when an entity reference is in the source document,
 or when the user wishes to insert an entity reference.
*/
public class EntityReference extends DOMNode  {
	protected EntityReference(Class dummy){super((Class) null);}

	private native void newEntityReference();
	public EntityReference() {
		super((Class) null);
		newEntityReference();
	}
	private native void newEntityReference( EntityReference other);
	public EntityReference( EntityReference other) {
		super((Class) null);
		newEntityReference( other);
	}
	private native void newEntityReference( DOMNode other);
	public EntityReference( DOMNode other) {
		super((Class) null);
		newEntityReference( other);
	}
	protected native void finalize() throws InternalError;
//	private native void newEntityReference( EntityReferenceImpl* i);
//	public EntityReference( EntityReferenceImpl* i) {
//		super((Class) null);
//		newEntityReference( i);
//	}
}
