/***************************************************************************
                            KAlphaPainter.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class includes some static methods to handle easier icons (or images)
 with an alpha channel.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.

 @author Antonio Larrosa <larrosa@kde.org>
 
 @short Methods to easily draw/blend images with an alpha channel.

*/
public class  KAlphaPainter implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KAlphaPainter(Class dummy){}


/** 
 Draws an image ( <code>icon</code> ) which has an alpha channel using the painter
 <code>p.</code> 
 <code>background</code> is the background image over which the icon is being painted
 (note that <code>background</code> contains the whole picture, and doesn't have to
 be of the same size than <code>icon</code>).

 <code>x</code> and <code>y</code> specify the point on <code>p</code> (and on <code>bg</code>) over which  <code>icon</code>
 will be painted.

 If <code>copyOnBg</code> is false (the default), the image will be drawn only on the
 PaintDevice which <code>p</code> is using. If <code>copyOnBg</code> is true, the icon will
 also be painted over the <code>background</code> image, so that next calls to this
 method for overlapped icons result in a correct image.

 If <code>relativeBg</code> is true, the background upperleft corner (background(0,0)
 point) is x,y, that is, it's not the whole background, but just a portion
 of it, starting where the icon will be painted. This can be used in applications
 that don't want to store the whole background if it can become too big.

*/
	public static native boolean draw( QPainter p, QImage icon, QImage background, int x, int y, boolean copyOnBg, int bgx, int bgy);
	public static native boolean draw( QPainter p, QImage icon, QImage background, int x, int y);

/** 
 Method provided by convenience which takes the background as a QPixmap
 object. Note that in this case, copyOnBg is still not implemented.
   
*/
	public static native boolean draw( QPainter p, QImage icon, QPixmap background, int x, int y, boolean copyOnBg, int bgx, int bgy);
	public static native boolean draw( QPainter p, QImage icon, QPixmap background, int x, int y);

/** 
 Method provided by convenience which takes the background as a QPixmap
 object.
   
*/
	public static native boolean draw( QPainter p, QPixmap icon, QImage background, int x, int y, boolean copyOnBg, int bgx, int bgy);
	public static native boolean draw( QPainter p, QPixmap icon, QImage background, int x, int y);
	public static native boolean draw( QPainter p, QPixmap icon, QPixmap background, int x, int y, int bgx, int bgy);
	public static native boolean draw( QPainter p, QPixmap icon, QPixmap background, int x, int y);
}
