/***************************************************************************
                            KBugReport.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A dialog box for sending bug reports.
 All the information needed by the dialog box
 (program name, version, bug-report address, etc.)
 comes from the {@link KAboutData} class.
 Make sure you create an instance of KAboutData and pass it
 to {@link KCmdLineArgs}.

 @author David Faure <faure@kde.org>
 
 @short A dialog box for sending bug reports.

*/
public class KBugReport extends KDialogBase  {
	protected KBugReport(Class dummy){super((Class) null);}


/** 
 Creates a bug-report dialog.
 Note that you shouldn't have to do this manually,
 since {@link KHelpMenu} takes care of the menu item
 for "Report Bug..." and of creating a KBugReport dialog.
   
*/
	private native void newKBugReport( QWidget parent, boolean modal, KAboutData aboutData);
	public KBugReport( QWidget parent, boolean modal, KAboutData aboutData) {
		super((Class) null);
		newKBugReport( parent, modal, aboutData);
	}
	private native void newKBugReport();
	public KBugReport() {
		super((Class) null);
		newKBugReport();
	}

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;
	protected native String text();
	protected native boolean sendBugReport();

/** 
 "Configure email" has been clicked - this calls kcmshell System/email
   
*/
	protected native void slotConfigureEmail();

/** 
 Sets the "From" field from the e-mail configuration
 Called at creation time, but also after "Configure email" is closed.
   
*/
	protected native void slotSetFrom();

/** 
 The URL-Label "http://bugs.kde.org/" was clicked.
   
*/
	protected native void slotUrlClicked( String arg1);

/** 
 OK has been clicked
   
*/
	protected native void slotOk();

/** 
 Cancel has been clicked
   
*/
	protected native void slotCancel();
	protected native void appChanged( int arg1);
	protected native void updateURL();
}

/** Override these methods in subclasses of KBugReport to customise event handling behaviour */
interface KBugReportEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

