/***************************************************************************
                            KButtonBox.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Container widget for buttons. 

 This class uses Qt layout control to place the buttons; can handle
 both vertical and horizontal button placement.  The default border
 is now <code>0</code> (making it easier to deal with layouts). The space
 between buttons is now more Motif compliant.

 @author Mario Weilguni <mweilguni@sime.com>

 @version $Id: KButtonBox.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short 
 Container widget for buttons.
*/
public class KButtonBox extends QWidget  {
	protected KButtonBox(Class dummy){super((Class) null);}


/** 
 Create an empty container for buttons.

 If <code>_orientation</code> is <code>Vertical</code>, the buttons inserted with 
 {@link #addButton} are laid out from top to bottom, otherwise they 
 are laid out from left to right.
    
*/
	private native void newKButtonBox( QWidget parent, int _orientation, int border, int _autoborder);
	public KButtonBox( QWidget parent, int _orientation, int border, int _autoborder) {
		super((Class) null);
		newKButtonBox( parent, _orientation, border, _autoborder);
	}
	private native void newKButtonBox( QWidget parent);
	public KButtonBox( QWidget parent) {
		super((Class) null);
		newKButtonBox( parent);
	}

/** 
 Free private data field
    
*/
	protected native void finalize() throws InternalError;

/** 

 This size is
 calculated by the width/height of all buttons plus border/autoborder.
    
*/
	public native QSize sizeHint();

/** 
 Add a new {@link QPushButton}.  

*/
	public native QPushButton addButton( String text, boolean noexpand);
	public native QPushButton addButton( String text);

/** 
 Add a new {@link QPushButton}.  

*/
	public native QPushButton addButton( String text, QObject receiver, String slot, boolean noexpand);
	public native QPushButton addButton( String text, QObject receiver, String slot);

/** 
 Add a stretch to the buttonbox. 

 Can be used to separate buttons.  That is, if you add the
 buttons OK and Cancel, add a stretch, and then add the button Help,
 the buttons OK and Cancel will be left-aligned (or top-aligned
 for vertical) whereas Help will be right-aligned (or
 bottom-aligned for vertical).

  /
 This function must be called <em>once</em> after all buttons have been
 inserted.

 It will start layout control.
    
*/
	public native QLayout layout();

/** 

*/
	protected native QSize bestButtonSize();
	protected native void placeButtons();
	protected native QSize buttonSizeHint( QPushButton arg1);
}

/** Override these methods in subclasses of KButtonBox to customise event handling behaviour */
interface KButtonBoxEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

