/***************************************************************************
                            KCModule.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The base class for control center modules.

 In KDE 2.0, control center modules are realized as shared
 libraries that are loaded into the control center at
 runtime.

 The module in principle is a simple widget displaying the
 item to be changed. The module has a very small interface.

 All the necessary glue logic and the GUI bells and whistles
 are provided by the control center and must not concern
 the module author.

 To write a config module, you have to create a library
 that contains at least one factory function like this:

 <pre>
   extern "C" {
     KCModule create_xyz(QWidget parent, String name)
     {
       return new XYZ(parent, name);
     }
   }
 </pre>

 See kdebase/kcontrol/HOWTO for more detailed documentation.

 @author Matthias Hoelzer-Kluepfel <hoelzer@kde.org>
 
 @short 
 The base class for control center modules.
*/
public class KCModule extends QWidget  {
	protected KCModule(Class dummy){super((Class) null);}

	private native void newKCModule( QWidget parent, String name);
	public KCModule( QWidget parent, String name) {
		super((Class) null);
		newKCModule( parent, name);
	}
	private native void newKCModule();
	public KCModule() {
		super((Class) null);
		newKCModule();
	}

/** 
 Load the configuration data into the module.

 The load method sets the user interface elements of the
 module to reflect the current settings stored in the
 configuration files.

 This method is invoked whenever the module should read its configuration
 (most of the times from a config file) and update the user interface.
 This happens when the user clicks the "Reset" button in the control
 center, to undo all of his changes and restore the currently valid
 settings. NOTE that this is not called after the modules is loaded,
 so you probably want to call this method in the constructor.
   
*/
	public native void load();

/** 
 Save the configuration data.

 The save method stores the config information as shown
 in the user interface in the config files.

 If necessary, this method also updates the running system,
 e.g. by restarting applications.

 save is called when the user clicks "Apply" or "Ok".
   
*/
	public native void save();

/** 
 Set the configuration to sensible default values.

 This method is called when the user clicks the "Default"
 button. It should set the display to useful values.
   
*/
	public native void defaults();

/** 
 Set the configuration to system default values.

 This method is called when the user clicks the "System-Default"
 button. It should set the display to the system default values.

 NOTE: The default behaviour is to call defaults().
   
*/
	public native void sysdefaults();

/** 
 Return a quick-help text.

 This method is called when the module is docked.
 The quick-help text should contain a short description of the module and
 links to the module's help files. You can use QML formating tags in the text.

 NOTE: Please make sure the quick help text gets translated (use i18n()).
   
*/
	public native String quickHelp();

/** 
 Returns a the KAboutData for this module
 This is generally only called for the KBugReport.
 Override and have it return a pointer to a constant
   
*/
	public native KAboutData aboutData();

/** 
 Indicate which buttons will be used.

 The return value is a value or'ed together from
 the Button enumeration type.

*/
	public native int buttons();

/** 
 Realizes the settings in the config files.

 This method may be called during system startup to apply the
 information in the config files to the running system.

 Note that this method is static, so it is not necessary to
 create an instance of the module at system startup.
 Generally, it should be avoided to construct GUI elements
 in this method.
   
*/
	public static native void init();

/** 
 Set the buttons to display.

 Help: shows a "Help" button.
 Default: shows a "Use Defaults" button
 Apply: in kcontrol this will show an "Apply" and "Reset" button
        in kcmshell this will show an "Ok", "Apply" and "Cancel" button

 If Apply is not specified, kcmshell will show a "Close" button.

*/
	protected native void setButtons( int btn);
	public static final int Help = 1;
	public static final int Default = 2;
	public static final int Apply = 16;
	public static final int Reset = 4;
	public static final int Cancel = 8;
	public static final int Ok = 32;
	public static final int SysDefault = 64;
}

/** Override these methods in subclasses of KCModule to customise event handling behaviour */
interface KCModuleEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

