/***************************************************************************
                            KCharSelectTable.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A table widget which displayes the characters of a font. Internally
 used by KCharSelect. See the KCharSelect documentation for further
 details.

 @author Reginald Stadlbauer <reggie@kde.org>
 
 @version $Id: KCharSelectTable.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short Character-Selection Table.
*/
public class KCharSelectTable extends QTableView  {
	protected KCharSelectTable(Class dummy){super((Class) null);}

	private native void newKCharSelectTable( QWidget parent, String name, String _font, QChar _chr, int _tableNum);
	public KCharSelectTable( QWidget parent, String name, String _font, QChar _chr, int _tableNum) {
		super((Class) null);
		newKCharSelectTable( parent, name, _font, _chr, _tableNum);
	}
	public native QSize sizeHint();
	public native void setFont( String _font);
	public native void setChar( QChar _chr);
	public native void setTableNum( int _tableNum);
	public native QChar chr();
//	protected native void paintCell( class QPainter* p, int row, int col);
	protected native void gotoLeft();
	protected native void gotoRight();
	protected native void gotoUp();
	protected native void gotoDown();
}

/** Override these methods in subclasses of KCharSelectTable to customise event handling behaviour */
interface KCharSelectTableEventHandling {
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent e);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent e);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent e);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

