/***************************************************************************
                            KCharsets.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Charset font and encoder/decoder handling.

 This is needed, because Qt's font matching algorithm gives the font
 family a higher priority than the charset.  For many applications
 this is not acceptable, since it can totally obscure the output,
 in languages which use non iso-8859-1 charsets.

 @author Lars Knoll <knoll@kde.org>

 @version $Id: KCharsets.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short 
 Charset font and encoder/decoder handling.
*/
public class  KCharsets implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCharsets(Class dummy){}


/**  destructor 
*/
	protected native void finalize() throws InternalError;

/** 
 provided for compitibility.
     
*/
	public native QTextCodec codecForName( String name);

/** 
 tries to find a QTextCodec to convert the given encoding from and to
 Unicode. If no codec could be found the latin1 codec will be returned an
 ok will be set to false.
     
*/
	public native QTextCodec codecForName( String n, boolean ok);

/** 

*/
	public native int charsetForEncoding( String encoding);

/** 
 overloaded member function. Usually you don't mind getting unicode charsets, so
 this method should rarely be needed.
     
*/
	public native int charsetForEncoding( String e, boolean noUnicode);

/** 
 converts an entity to a character. The string must contain only the
 entity without the trailing ';'.

*/
	public native QChar fromEntity( String str);

/** 
 Overloaded member function. Tries to find an entity in the
 {@link String} str.

*/
	public native QChar fromEntity( String str, int len);

/** 
 converts a QChar to an entity. The returned string does already
 contain the leading '&' and the trailing ';'.
     
*/
	public native String toEntity( QChar ch);

/** 
 as above, but returns the names of the charsets
     
*/
	public native ArrayList availableCharsetNames( String family);

/** 
 Lists all available encodings as names.
         
*/
	public native ArrayList availableEncodingNames();

/** 
 Lists the available encoding names together with a more descriptive language.
     
*/
	public native ArrayList descriptiveEncodingNames();

/** 
 returns the language the encoding is used for. 
     
*/
	public native String languageForEncoding( String encoding);

/** 
 returns the encoding for a string obtained with descriptiveEncodingNames()
     
*/
	public native String encodingForName( String descriptiveName);

/** 

*/
	public native QFont fontForChar( QChar ch, QFont f);

/** 

*/
	public native ArrayList availableFamilies( int ch);

/** 
 sets the {@link QFont} f to the charset given in charset.
 Opposed to {@link QFont}'s setCharset() function, this function will do
 it's best to find a font which can display the given charset. It might
 change the font's family for this purpose, but care is taken to find
 a family which is as close as possible to the font given.
     
*/
	public native void setQFont( QFont f, int charset);
	public native void setQFont( QFont f);

/** 
 overloaded member function. Provided for convenience.
     
*/
	public native void setQFont( QFont f, String charset);

/** 

*/
	public native String name( QFont f);

/** 

*/
	public native String name( int c);

/** 
 is a font with the given charset available?
     
*/
	public native boolean isAvailable( int charset);

/** 
 overloaded member function. Provided for convenience.
     
*/
	public native boolean isAvailable( String charset);

/** 

*/
	public native int charsetForLocale();

/** 
 does the given font family have a unicode encoding?
     
*/
	public native boolean hasUnicode( String family);

/** 
 does given font exist with a unicode encoding?
     
*/
	public native boolean hasUnicode( QFont font);

/** 
 does the give font support the script given by charset?
 This can return tru in two cases: Either the font is in the
 right charset  or it is a unicode font containing glyphs to display
 this charset.

 There are some exceptions. A 8859-6 font will return false if asked
 if it supports the 8859-6 charset, because we need a unicode font
 to properly display arabic.
     
*/
	public native boolean supportsScript( QFont f, int charset);
	public native String xCharsetName( int arg1);
	public native int nameToID( String name);
	public native int xNameToID( String name);

/**  protected constructor. If you need the kcharsets object, use
        {@link KGlobal#charsets} instead.
    
*/
	private native void newKCharsets();
	public KCharsets() {
		newKCharsets();
	}
	public static final int FixedUnknown = 0;
	public static final int Fixed = 1;
	public static final int Proportional = 2;
	public static final int WeightUnknown = 0;
	public static final int Medium = 1;
	public static final int Bold = 2;
	public static final int SlantUnknown = 0;
	public static final int Normal = 1;
	public static final int Italic = 2;
}
