/***************************************************************************
                            KCodecs.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A wrapper class for the most commonly used encoding and
 decoding algorithms.  Currently it provides encoding and
 decoding facilities for the base64, uuencode/uudecode
 and quoted-printable algorithms.

 @section Useage:

 <PRE>
 QCString input = "Aladdin:open sesame";
 QCString result = KCodecs.base64Encode( input );
 printf ( "Result: %c", result.data() );
 </PRE>

 Output should be
 Result: QWxhZGRpbjpvcGVuIHNlc2FtZQ==

 <u>NOTE:</u> A unit test program is available under the tests
 directory that exercises all the codecs provided here.  You
 can compile the unit test program under <code>kdelibs</code>/kio/tests
 by doing <code></code>"make kmdcodectest".

 @author Rik Hemsley <rik@kde.org>
 
 @short A collection of commonly used encoding/decoding algorithms.

*/
public class  KCodecs implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCodecs(Class dummy){}


/** 
 Encodes the given data using the uuencode algorithm.

 The output is split into lines starting with the number of
 encoded octets in the line and ending with a newline.  No
 line is longer than 45 octets (60 characters), excluding the
 line terminator.

 <u>NOTE:</u> <code>data</code> should be just the actual data.  Any
 'begin' and 'end' lines such as those generated by a nix
 <code>uuencode</code> utility must not be included.

*/
	public static native String uuencode( byte[] in);

/** 
 Encodes the given data using the uuencode algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 <u>NOTE:</u> the output array is first reset and then
 resized to the appropriate size.

*/
	public static native void uuencode( byte[] in, byte[] out);

/** 
 Encodes the given string using the uuencode algorithm.

*/
	public static native String uuencode( String str);

/** 
 Decodes the given data using the uuencode algorithm.

 <u>NOTE:</u> <code>data</code> should be just the actual data.
 Any 'begin' and 'end' lines such as those generated by
 nix utilities must NOT be included.

*/
	public static native String uudecode( byte[] in);

/** 
 Decodes the given data using the uudecode algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 <u>NOTE:</u> the output array is first reset and then
 resized to the appropriate size.

*/
	public static native void uudecode( byte[] in, byte[] out);

/** 
 Decodes a uuencoded string.

*/
	public static native String uudecode( String str);

/** 
 Encodes the given data using the quoted-printable algorithm.

*/
	public static native String quotedPrintableEncode( byte[] in);

/** 
 Decodes a quoted-printable encoded string.

*/
	public static native byte[] quotedPrintableDecode( String in);

/** 
 Encodes the given data using the base64 algorithm.

*/
	public static native String base64Encode( byte[] in);

/** 
 Encodes the given data using the base64 algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 <u>NOTE:</u> the output array is first reset and then
 resized to the appropriate size.

*/
	public static native void base64Encode( byte[] in, byte[] out);

/** 
 Encodes the given string using the base64 algorithm.

*/
	public static native String base64Encode( String str);

/** 
 Decodes the given data that was encoded using the base64 algorithm.

*/
	public static native String base64Decode( byte[] in);

/** 
 Decodes the given data that was encoded with the base64 algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 <u>NOTE:</u> the output array is first reset and then
 resized to the appropriate size.

*/
	public static native void base64Decode( byte[] in, byte[] out);

/** 
 Decodes a string encoded with the base64 algorithm.

*/
	public static native String base64Decode( String str);

/** 
 Encodes the String data using the base64 algorithm.

 <u>IMPORTANT:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 encoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String base64Encode( String str);

/** 
 Decodes the encoded String data using the base64 algorithm.

 <u>IMPORTANT:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 decoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String base64Decode( String str);

/** 
 Encodes the String data using the uuencode algorithm.

 <u>IMPORTANT:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 encoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String uuencode( String str);

/** 
 Decodes the String data using the uuencode algorithm.

 <u>IMPORTANT:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 decoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String uudecode( String str);

/** 

   
*/
	public static native String encodeString( String data);

/** 

   
*/
	public static native String decodeString( String data);
}
