/***************************************************************************
                            KCommand.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The abstract base class for all Commands. Commands are used to
 store information needed for Undo/Redo functionality...
 
 @short 
 The abstract base class for all Commands.
*/
public class  KCommand implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCommand(Class dummy){}

	protected native void finalize() throws InternalError;

/** 
 The main method: execute this command.
 Implement here what this command is about, and remember to
 record any information that will be helpful for {@link unexecute}.
     
*/
	public native void execute();

/** 
 Unexecute (undo) this command.
 Implement here the steps to take for undoing the command.
 If your application uses actions for everything (it should),
 and if you implement unexecute correctly, the application is in the same
 state after unexecute as it was before execute. This means, the next
 call to execute will do the same thing as it did the first time.
     
*/
	public native void unexecute();

/** 

*/
	public native String name();

/** 
 Update the name of this command.
 Rarely necessary.
     
*/
	public native void setName( String name);

/** 
 Creates a command

*/
}
