/***************************************************************************
                            KCompletionBox.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A little utility class for "completion-widgets", like KLineEdit or
 KComboBox. KCompletionBox is a listbox, displayed as a rectangle without
 any window-decoration, usually directly under the lineedit or combobox.
 It is filled with all possible matches for a completion, so the user
 can select the one he wants.

 It is used when KGlobalSettings.Completion == CompletionPopup.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A helper widget for "completion-widgets" (KLineEdit, KComboBox)).
*/
public class KCompletionBox extends KListBox  {
	protected KCompletionBox(Class dummy){super((Class) null);}


/** 
 Constructs a KCompletionBox.

 Notice: the parent needs to be always null,
 so you can't specify it in the constructor. Because of that, Qt's
 auto-deletion does not take place, so you have to explicitly delete
 this widget when you don't need it anymore.

 The parent widget is used to give the focus back when pressing the
 up-button on the very first item.
     
*/
	private native void newKCompletionBox( QWidget parent, String name);
	public KCompletionBox( QWidget parent, String name) {
		super((Class) null);
		newKCompletionBox( parent, name);
	}
	private native void newKCompletionBox( QWidget parent);
	public KCompletionBox( QWidget parent) {
		super((Class) null);
		newKCompletionBox( parent);
	}

/** 
 Destroys the box
     
*/
	protected native void finalize() throws InternalError;
	public native QSize sizeHint();

/** 
 Sets the text emitted if this box is closed without selecting an item.

 By default, a null string is emitted if the user presses cancel or
 clicks elsewhere to close this completion box widget.

*/
	public native void setCancelledText( String arg1);

/** 

*/
	public native ArrayList items();

/** 
 Adjusts the size of the box to fit the width of the parent given in the
 constructor and pops it up at the most appropriate place, relative to
 the parent.

 Depending on the screensize and the position of the parent, this may
 be a different place, however the default is to pop it up and the
 lower left corner of the parent.

 Make sure to hide() the box when appropriate.
     
*/
	public native void popup();

/** 
 Move the selection one line down or select the first item if nothing is selected yet.
     
*/
	public native void down();

/** 
 Move the selection one line up or select the first item if nothing is selected yet.
     
*/
	public native void up();

/** 
 Move the selection one page down.
     
*/
	public native void pageDown();

/** 
 Move the selection one page up.
     
*/
	public native void pageUp();

/** 
 Move the selection up to the first item.
     
*/
	public native void home();

/** 
 Move the selection down to the last item.
     
*/
	public native void end();

/**  Re-implemented for internal reasons.  API is not affected. 
*/
	public native void show();

/**  Re-implemented for internal reasons.  API is not affected. 
*/
	public native void hide();

/** 
 Reimplemented from KListBox to get events from the viewport (to hide
 this widget on mouse-click, Escape-presses, etc.
     
*/
	public native boolean eventFilter( QObject arg1, QEvent arg2);

/** 
 Invoked if the user choose to ignore the current selection and close
 this widget.
     
*/
	protected native void cancelled();

/** 
 Called when an item was activated. Emits
 {@link #activated} with the item.
     
*/
	protected native void slotActivated( QListBoxItem arg1);
}

/** Override these methods in subclasses of KCompletionBox to customise event handling behaviour */
interface KCompletionBoxEventHandling {

/** 

   
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);

/** 

   
*/
	void focusOutEvent(QFocusEvent fe);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);

/** 

   
*/
	void leaveEvent(QEvent e);
	void showEvent(QShowEvent arg1);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void contentsDropEvent(QDropEvent arg1);
	void focusInEvent(QFocusEvent e);
	void contentsDragLeaveEvent(QDragLeaveEvent arg1);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);

/** 

   
*/
	void contentsMouseDoubleClickEvent(QMouseEvent e);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void contentsMouseReleaseEvent(QMouseEvent arg1);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent arg1);
	void contentsMouseMoveEvent(QMouseEvent arg1);

/** 

   
*/
	void contentsMousePressEvent(QMouseEvent e);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

