/***************************************************************************
                            KConfigBase.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Abstract base class for KDE configuration entries.

 This class forms the base for all KDE configuration. It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. Either use {@link #KConfig} or {@link #KSimpleConfig}, or
 even {@link #KSharedConfig}.

 All configuration entries are key, value pairs.  Each entry also
 belongs to a specific group of related entries.  All configuration
 entries that do not explicitly specify which group they are in are
 in a special group called the default group.

 If there is a $ character in an entry, {@link KConfigBase} tries to expand
 environment variable and uses its value instead of its name. You
 can avoid this feature by having two consecutive $ characters in
 your config file which get expanded to one.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: KConfigBase.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short KDE Configuration Management abstract base class.
*/
public class KConfigBase extends QObject  {
	protected KConfigBase(Class dummy){super((Class) null);}


/** 
 Construct a KConfigBase object.
   
*/

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Specify the group in which keys will be searched.

  Subsequent
 calls to {@link #readEntry} will look only for keys in the currently
 activated group.

 Switch back to the default group by passing an empty string.

*/
	public native void setGroup( String pGroup);

/** 
 Set the group to the "Desktop Entry" group used for
 desktop configuration files for applications, mime types, etc.
   
*/
	public native void setDesktopGroup();

/** 
 Retrieve the name of the group in which we are
  searching for keys and from which we are retrieving entries.

*/
	public native String group();

/** 
 Returns <code>true</code> if the specified group is known about.

*/
	public native boolean hasGroup( String _pGroup);

/** 
 Retrieve a list of groups that are known about.

*/
	public native ArrayList groupList();

/** 
 Retrieve a the current locale.

*/
	public native String locale();

/** 
 Read the value of an entry specified by <code>pKey</code> in the current group.

*/
	public native String readEntry( String pKey, String aDefault);
	public String readEntry( String pKey)
	{
		return readEntry(pKey, null);
	}
//	public native String readEntry( String pKey, String aDefault);

/** 
 Read the value of an entry specified by <code>pKey</code> in the current group.
 The value is treated as if it is of the given type.

*/
	public native QVariant readPropertyEntry( String pKey, int arg1);
//	public native QVariant readPropertyEntry( String pKey, int arg1);

/** 
 Read a list of strings.

*/
	public native int readListEntry( String pKey, String[] list, char sep);
	public native int readListEntry( String pKey, String[] list);
//	public native int readListEntry( String pKey, String[] list, char sep);
//	public native int readListEntry( String pKey, String[] list);

/** 
 Read a list of strings.

*/
	public native ArrayList readListEntry( String pKey, char sep);
//	public native ArrayList readListEntry( String pKey, char sep);

/** 
 Read a path.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a path. This means, dollar expansion is activated
 for this value, so that e.g. $HOME gets expanded.

*/
	public native String readPathEntry( String pKey, String aDefault);
//	public native String readPathEntry( String pKey, String aDefault);

/** 
 Read a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native int readNumEntry( String pKey, int nDefault);
	public native int readNumEntry( String pKey);
//	public native int readNumEntry( String pKey, int nDefault);
//	public native int readNumEntry( String pKey);

/** 
 Read a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native int readUnsignedNumEntry( String pKey, int nDefault);
	public native int readUnsignedNumEntry( String pKey);
//	public native int readUnsignedNumEntry( String pKey, int nDefault);
//	public native int readUnsignedNumEntry( String pKey);

/** 
 Read a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native long readLongNumEntry( String pKey, long nDefault);
	public native long readLongNumEntry( String pKey);
//	public native long readLongNumEntry( String pKey, long nDefault);
//	public native long readLongNumEntry( String pKey);

/** 
 Read a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native long readUnsignedLongNumEntry( String pKey, long nDefault);
	public native long readUnsignedLongNumEntry( String pKey);
//	public native long readUnsignedLongNumEntry( String pKey, long nDefault);
//	public native long readUnsignedLongNumEntry( String pKey);

/** 
 Read a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native double readDoubleNumEntry( String pKey, double arg1);
	public native double readDoubleNumEntry( String pKey);
//	public native double readDoubleNumEntry( String pKey, double arg1);
//	public native double readDoubleNumEntry( String pKey);

/** 
 Read a {@link QFont}.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a font object.

*/
	public native QFont readFontEntry( String pKey, QFont pDefault);
	public native QFont readFontEntry( String pKey);
//	public native QFont readFontEntry( String pKey, QFont pDefault);
//	public native QFont readFontEntry( String pKey);

/** 
 Read a boolean entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a boolean value. Currently "on" and "true" are
 accepted as true, everything else if false.

*/
	public native boolean readBoolEntry( String pKey, boolean bDefault);
	public native boolean readBoolEntry( String pKey);
//	public native boolean readBoolEntry( String pKey, boolean bDefault);
//	public native boolean readBoolEntry( String pKey);

/** 
 Read a rect entry.

 Read the value of an entry specified by pKey in the current group
 and interpret it as a {@link QRect} object.

*/
	public native QRect readRectEntry( String pKey, QRect pDefault);
//	public native QRect readRectEntry( String pKey, QRect pDefault);

/** 
 Read a point entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a {@link QPoint} object.

*/
	public native QPoint readPointEntry( String pKey, QPoint pDefault);
//	public native QPoint readPointEntry( String pKey, QPoint pDefault);

/** 
 Read a size entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a {@link QSize} object.

*/
	public native QSize readSizeEntry( String pKey, QSize pDefault);
//	public native QSize readSizeEntry( String pKey, QSize pDefault);

/** 
 Read a {@link QColor}.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a color.

*/
	public native QColor readColorEntry( String pKey, QColor pDefault);
	public native QColor readColorEntry( String pKey);
//	public native QColor readColorEntry( String pKey, QColor pDefault);
//	public native QColor readColorEntry( String pKey);

/** 
 Read a {@link QDateTime}.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a date and time.

*/
	public native Calendar readDateTimeEntry( String pKey, Calendar pDefault);
//	public native Calendar readDateTimeEntry( String pKey, Calendar pDefault);

/** 
 Write the key/value pair.

 This is stored in the most specific config file when destroying the
 config object or when calling {@link #sync}.

*/
	public native String writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public String writeEntry( String pKey, String pValue)
	{
		return writeEntry(pKey, pValue, true, false, false);
	}
//	public native String writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 {@link #writeEntry} Overridden to accept a property.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QVariant rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QVariant rValue);
//	public native void writeEntry( String pKey, QVariant rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QVariant rValue);

/** 
 {@link #writeEntry} overriden to accept a list of strings.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, String[] rValue);
//	public native void writeEntry( String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String[] rValue);

/** 
 {@link #writeEntry} overridden to accept a list of strings.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
//	public native void writeEntry( String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String[] rValue);
//	public native void writeEntry( String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String[] rValue);

/** 
 Write the key/value pair.

 This is stored to the most specific config file when destroying the
 config object or when calling {@link #sync}.

*/
//	public native String writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native String writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write a numerical value.

*/
	public native String writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public String writeEntry( String pKey, int nValue)
	{
		return writeEntry(pKey, nValue, true, false, false);
	}
//	public native String writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write an unsigned numerical value.

*/
//	public native String writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native String writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write a long numerical value.

*/
	public native String writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native String writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write an unsigned long numerical value.

*/
//	public native String writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native String writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write a floating-point value.

*/
//	public native String writeEntry( String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format 'g' arg1, int precision, boolean bNLS);
//	public native String writeEntry( String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format 'g' arg1, int precision, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write a boolean value.

*/
	public native String writeEntry( String pKey, boolean bValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public String writeEntry( String pKey, boolean bValue)
	{
		return writeEntry(pKey, bValue, true, false, false);
	}
//	public native String writeEntry( String pKey, boolean bValue, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write a font

*/
	public native String writeEntry( String pKey, QFont rFont, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native String writeEntry( String pKey, QFont rFont, boolean bPersistent, boolean bGlobal, boolean bNLS);

/** 
 Write the key value pair.
 Same as above, but write a color.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QColor rColor, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QColor rColor);
//	public native void writeEntry( String pKey, QColor rColor, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QColor rColor);

/** 
 Write the key value pair.
 Same as above, but write a date and time.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 <em>not</em> returned here!

*/
	public native void writeEntry( String pKey, Calendar rDateTime, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, Calendar rDateTime);
//	public native void writeEntry( String pKey, Calendar rDateTime, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, Calendar rDateTime);

/** 
 Write the key value pair.
 Same as above, but write a rectangle.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QRect rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QRect rValue);
//	public native void writeEntry( String pKey, QRect rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QRect rValue);

/** 
 Write the key value pair.
 Same as above, but write a point.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QPoint rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QPoint rValue);
//	public native void writeEntry( String pKey, QPoint rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QPoint rValue);

/** 
 Write the key value pair.
 Same as above, but write a size.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QSize rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QSize rValue);
//	public native void writeEntry( String pKey, QSize rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QSize rValue);

/** 
 Turns on or off "dollar  expansion" (see {@link KConfigBase} introduction)
  when reading config entries.
 Dollar sign expansion is initially OFF.

*/
	public native void setDollarExpansion( boolean _bExpand);
	public native void setDollarExpansion();

/** 
 Returns whether dollar expansion is on or off.  It is initially OFF.

*/
	public native boolean isDollarExpansion();

/** 
 Mark the config object as "clean," i.e. don't write dirty entries
 at destruction time. If <code>bDeep</code> is false, only the global dirty
 flag of the KConfig object gets cleared. If you then call
 {@link #writeEntry} again, the global dirty flag is set again and all
 dirty entries will be written at a subsequent {@link #sync} call.

 Classes that derive from {@link KConfigObject} should override this
 method and implement storage-specific behaviour, as well as
 calling the {@link KConfigBase#rollback} explicitly in the initializer.

*/
	public native void rollback( boolean bDeep);
	public native void rollback();

/** 
 Flush all changes that currently reside only in memory
 back to disk / permanent storage. Dirty configuration entries are
 written to the most specific file available.

 Asks the back end to flush out all pending writes, and then calls
 {@link #rollback}.  No changes are made if the object has <code>readOnly</code>
 status.

 You should call this from your destructor in derivative classes.

*/
	public native void sync();

/** 

*/
	public native boolean isDirty();

/** 
 Set the config object's read-only status.

   
*/
	public native void setReadOnly( boolean _ro);

/** 
 Queries the read-only status of the config object.

*/
	public native boolean isReadOnly();

/** 
 Check whether the key has an entry in the currently active group.
 Use this to determine whether a key is not specified for the current
 group (hasKey() returns false). Keys with null data are considered
 nonexistent.

*/
	public native boolean hasKey( String pKey);

/** 
 Reparses all configuration files. This is useful for programs
 that use standalone graphical configuration tools. The base
 method implemented here only clears the group list and then
 appends the default group.

 Derivative classes should clear any internal data structures and
 then simply call {@link #parseConfigFiles} when implementing this
 method.

*/
	public native void reparseConfiguration();

/** 
 Retrieve the state of the app-config object.

 Possible return values
 are NoAccess (the application-specific config file could not be
 opened neither read-write nor read-only), ReadOnly (the
 application-specific config file is opened read-only, but not
 read-write) and ReadWrite (the application-specific config
 file is opened read-write).

*/
	public native int getConfigState();

/**  
 Overloaded public methods:
   
*/
//	public native void setGroup( String pGroup);
//	public native void setGroup( String pGroup);
//	public native boolean hasGroup( String _pGroup);
//	public native boolean hasGroup( String _pGroup);
//	public native boolean hasKey( String pKey);
	public static final int NoAccess = 0;
	public static final int ReadOnly = 1;
	public static final int ReadWrite = 2;
}
