/***************************************************************************
                            KCursor.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A wrapper around {@link QCursor} that allows for "themed" cursors.

 Currently, the only themed cursor is a hand shaped cursor.

 A typical usage would be
 <PRE>
 	setCursor(KCursor.handCursor());
 </PRE>

 @author Kurt Granroth <granroth@kde.org>
 
 @short A QCursor wrapper allowing "themed" cursors and auto-hiding cursors.

*/
public class  KCursor implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCursor(Class dummy){}


/** 
 Constructor.

 Does not do anything so far.

*/
	private native void newKCursor();
	public KCursor() {
		newKCursor();
	}

/** 
 Retrieve the proper hand cursor according to
 the current GUI style (static function).
     
*/
	public static native QCursor handCursor();

/** 
 Retrieve the proper arrow cursor according to
 the current GUI style (static function).
     
*/
	public static native QCursor arrowCursor();

/** 
 Retrieve the proper up arrow cursor according to
 the current GUI style (static function).
     
*/
	public static native QCursor upArrowCursor();

/** 
 Retrieve the proper cross-hair cursor according to
 the current GUI style (static function).
     
*/
	public static native QCursor crossCursor();

/** 
 Retrieve the proper hourglass cursor according to
 the current GUI style (static function).
     
*/
	public static native QCursor waitCursor();

/** 
 Retrieve the proper text cursor according to
 the current GUI style (static function).
     
*/
	public static native QCursor ibeamCursor();

/** 
 Retrieve the proper vertical resize cursor
 according to the current GUI style (static function).
     
*/
	public static native QCursor sizeVerCursor();

/** 
 Retrieve the proper horizontal resize cursor
 according to the current GUI style (static function).
     
*/
	public static native QCursor sizeHorCursor();

/** 
 Retrieve the proper diagonal resize (/) cursor
 according to the current GUI style (static function).
     
*/
	public static native QCursor sizeBDiagCursor();

/** 
 Retrieve the proper diagonal resize (\) cursor
 according to the current GUI style (static function).
     
*/
	public static native QCursor sizeFDiagCursor();

/** 
 Retrieve the proper all-directions resize cursor
 according to the current GUI style (static function).
     
*/
	public static native QCursor sizeAllCursor();

/** 
 Retrieve a blank or invisible cursor (static function).
     
*/
	public static native QCursor blankCursor();

/** 
 Sets auto-hiding the cursor for widget <code>w.</code> Enabling it will result in
 the cursor being hidden when

 The cursor will be shown again when the focus is lost or a mouse-event
 happens.

 Side effect: when enabling auto-hide, mouseTracking is enabled for the
 specified widget, because it's needed to get mouse-move-events. So
 don't disable mouseTracking for a widget while using auto-hide for it.

 When disabling auto-hide, mouseTracking will be disabled, so if you need
 mouseTracking after disabling auto-hide, you have to reenable
 mouseTracking.

 If you want to use auto-hiding for widgets that don't take focus, e.g.
 a QCanvasView, then you have to pass all key-events that should trigger
 auto-hiding to {@link #autoHideEventFilter}.
     
*/
	public static native void setAutoHideCursor( QWidget w, boolean enable);

/** 
 Overloaded method for the case where you have an event-filter installed
 on the widget you want to enable auto-cursor-hiding.

 In this case set <code>customEventFilter</code> to true and call
 {@link #autoHideEventFilter} from the beginning of your eventFilter().

*/
	public static native void setAutoHideCursor( QWidget w, boolean enable, boolean customEventFilter);

/** 
 Sets the delay time in milliseconds for auto-hiding. When no keyboard
 events arrive for that time-frame, the cursor will be hidden.

 Default is 5000, i.e. 5 seconds.
     
*/
	public static native void setHideCursorDelay( int ms);

/** 

 Default is 5000, i.e. 5 seconds.
     
*/
	public static native int hideCursorDelay();

/** 
 KCursor has to install an eventFilter over the widget you want to
 auto-hide. If you have an own eventFilter() on that widget and stop
 some events by returning true, you might break auto-hiding, because
 KCursor doesn't get those events.

 In this case, you need to call setAutoHideCursor( widget, true, true );
 to tell KCursor not to install an eventFilter. Then you call this method
 from the beginning of your eventFilter, for example:
 <pre>
 edit = new KEdit( this, "some edit widget" );
 edit.installEventFilter( this );
 KCursor.setAutoHideCursor( edit, true, true );

 [...]

 boolean YourClass.eventFilter( QObject o, QEvent e )
 {
     if ( o == edit ) // only that widget where you enabled auto-hide!
         KCursor.autoHideEventFilter( o, e );

     // now you can do your own event-processing
     [...]
 }
 </pre>

 Note that you must not call KCursor.autoHideEventFilter() when you
 didn't enable or after disabling auto-hiding.
     
*/
	public static native void autoHideEventFilter( QObject arg1, QEvent arg2);
}
