/***************************************************************************
                            KDCOPPropertyProxy.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KDCOPPropertyProxy class provides an easy way to publish Qt properties of a
 QObject through DCOP.

 The class provides DCOP equivalents for the Qt property methods setProperty() ,
 property() and propertyNames() and also provides automatic set/get methods for
 the properties of a QObject. That means for example if your object provides a
 String property called foo , then KDCOPPropertyProxy translates DCOP calls
 "setFoo( String )" and "String foo()" automatically into the corresponding
 setProperty/property calls.
 
 @short 
 The KDCOPPropertyProxy class provides an easy way to publish Qt properties of a
 QObject through DCOP.
*/
public class  KDCOPPropertyProxy implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KDCOPPropertyProxy(Class dummy){}


/** 
 Convenience constructor. Use it if you want to use this class as object, in contrary
 to using the static methods of this class and providing a QObject argument for each
 call.
   
*/
	private native void newKDCOPPropertyProxy( QObject object);
	public KDCOPPropertyProxy( QObject object) {
		newKDCOPPropertyProxy( object);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Convenience method, when using this class as object. See documentation of the constructor and
 static isPropertyRequest method.
   
*/
	public native boolean isPropertyRequest( String fun);

/** 
 Convenience method, when using this class as object. See documentation of the constructor and
 static processPropertyRequest method.
   
*/
	public native boolean processPropertyRequest( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 Returns true if the method request in the fun argument matches the signature of the three standard
 property methods or set/get methods for the properties of the object argument.

 Use this method in your own DCOPObject dispatcher to check if the DCOP request is a property
 request which can be handled by this class.
   
*/
	public static native boolean isPropertyRequest( String fun, QObject object);

/** 
 Processes the given DCOP method request by translating the request into a setProperty/property call
 on the given QObject argument.
   
*/
	public static native boolean processPropertyRequest( String fun, byte[] data, String replyType, byte[] replyData, QObject object);
}
