/***************************************************************************
                            KDEsuClient.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A client class to access kdesud, the KDE su daemon. Kdesud can assist in 
 password caching in two ways:

 @short 
 A client class to access kdesud, the KDE su daemon.
*/
public class  KDEsuClient implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KDEsuClient(Class dummy){}

	private native void newKDEsuClient();
	public KDEsuClient() {
		newKDEsuClient();
	}
	protected native void finalize() throws InternalError;

/** 
 Lets kdesud execute a command. If the daemon does not have a password
 for this command, this will fail and you need to call {@link #setPass}.

*/
	public native int exec( String command, String user);

/** 
 Set root's password, lasts one session.

*/
	public native int setPass( String pass, int timeout);

/** 
 Set the target host (optional).
     
*/
	public native int setHost( String host);

/** 
 Set the desired priority (optional), see {@link #StubProcess.}
     
*/
	public native int setPriority( int priority);

/** 
 Set the desired scheduler (optional), see {@link #StubProcess.}
     
*/
	public native int setScheduler( int scheduler);

/** 
 Remove a password for a user/command.

*/
	public native int delCommand( String command, String user);

/** 
 Set a persistent variable.

*/
	public native int setVar( String key, String value, int timeout, String group);
	public native int setVar( String key, String value);

/** 
 Get a persistent variable.

*/
	public native String getVar( String key);

/** 
 Returns true if the specified group exists is
 cached.

*/
	public native boolean findGroup( String group);

/** 
 Delete a persistent variable.

*/
	public native int delVar( String key);

/** 
 Delete all persistent variables with the given key.

 A specicalized variant of {@link #delVar} that
 removes all subsets of the cached varaibles given by
 <code>key.</code> In order for cached keys to be deleted by this
 function, the value given to the <code>group</code> argument of
 the {@link setVar} function must be a subset of the <code>key</code>
 argument used for the same function and the key given
 to here must be a superset and a subset the same group
 and key variables mentioned above respectively.  NOTE:
 simply giving the value of the group key will not work.
 You have to use {@link delGroup} under that circumstance.

*/
	public native int delVars( String special_key);

/** 
 Delete all persistent variables in a group.

*/
	public native int delGroup( String group);

/** 
 Ping kdesud. This can be used for diagnostics.

*/
	public native int ping();

/**  Stop the daemon.  
*/
	public native int stopServer();

/**  Try to start up kdesud 
*/
	public native int startServer();

/**  Returns true if the server is safe (installed setgid), false otherwise. 
*/
	public native boolean isServerSGID();
}
