/***************************************************************************
                            KDatePicker.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provide a widget for calendar date input.

     Different from the
     previous versions, it now emits two types of signals, either
     {@link #dateSelected} or {@link #dateEntered} (see documentation for both
     signals). 

     A line edit has been added in the newer versions to allow the user 
     to select a date directly by entering numbers like 19990101
     or 990101. 

 @author Tim Gilman, Mirko Boehm

 @version $Id: KDatePicker.java,v 1.3 2001/05/16 22:52:51 rdale Exp $

 @short A date selection widget.

*/
public class KDatePicker extends QFrame  {
	protected KDatePicker(Class dummy){super((Class) null);}


/**  The usual constructor.  The given date will be displayed 
 initially.

*/
	private native void newKDatePicker( QWidget parent, Calendar arg1, String name);
	public KDatePicker( QWidget parent, Calendar arg1, String name) {
		super((Class) null);
		newKDatePicker( parent, arg1, name);
	}
	private native void newKDatePicker();
	public KDatePicker() {
		super((Class) null);
		newKDatePicker();
	}

/** 
 The destructor. 

*/
	protected native void finalize() throws InternalError;

/**  The size hint for {@link KDatePickers}. The size hint recommends the
   minimum size of the widget so that all elements may be placed
  without clipping. This sometimes looks ugly, so when using the
  size hint, try adding 28 to each of the reported numbers of
  pixels.

*/
	public native QSize sizeHint();

/**  Set the date.

*/
	public native boolean setDate( Calendar arg1);

/**  
 Retrieve the date.

*/
	public native Calendar getDate();

/**  
 Enable or disable the widget. 

*/
	public native void setEnabled( boolean arg1);

/**  
 Set the font size of the widgets elements. 

*/
	public native void setFontSize( int arg1);

/** 
 Font size of the widget elements.
   
*/
	public native int fontSize();
	protected native void dateChangedSlot( Calendar arg1);
	protected native void tableClickedSlot();
	protected native void monthForwardClicked();
	protected native void monthBackwardClicked();
	protected native void yearForwardClicked();
	protected native void yearBackwardClicked();
	protected native void selectMonthClicked();
	protected native void selectYearClicked();
	protected native void lineEnterPressed();
}

/** Override these methods in subclasses of KDatePicker to customise event handling behaviour */
interface KDatePickerEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

