/***************************************************************************
                            KDateTable.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Date selection table.
 This is a support class for the KDatePicker class.  It just
 draws the calender table without titles, but could theoretically
 be used as a standalone.

 When a date is selected by the user, it emits a signal:
 dateSelected(QDate)

 @author Tim Gilman, Mirko Boehm
 
 @version $Id: KDateTable.java,v 1.3 2001/05/16 22:52:51 rdale Exp $

 @short 
 Date selection table.
*/
public class KDateTable extends QTableView  {
	protected KDateTable(Class dummy){super((Class) null);}


/**  The constructor. 
*/
	private native void newKDateTable( QWidget parent, Calendar arg1, String name, int f);
	public KDateTable( QWidget parent, Calendar arg1, String name, int f) {
		super((Class) null);
		newKDateTable( parent, arg1, name, f);
	}
	private native void newKDateTable();
	public KDateTable() {
		super((Class) null);
		newKDateTable();
	}

/**  Returns a recommended size for the widget.
	To save some time, the size of the largest used cell content is
	calculated in each paintCell() call, since all calculations have
	to be done there anyway. The size is stored in maxCell. The
	sizeHint() simply returns a multiple of maxCell. 
*/
	public native QSize sizeHint();

/**  Set the font size of the date table. 
*/
	public native void setFontSize( int size);

/**  Select and display this date. 
*/
	public native boolean setDate( Calendar arg1);
	public native Calendar getDate();

/**  Paint a cell. 
*/
	protected native void paintCell( QPainter arg1, int arg2, int arg3);
}

/** Override these methods in subclasses of KDateTable to customise event handling behaviour */
interface KDateTableEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);

/**  React on mouse clicks that select a date. 
*/
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);

/**  Handle the resize events. 
*/
	void resizeEvent(QResizeEvent arg1);
}

