/***************************************************************************
                            KDialog.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog with extended modeless support and methods for KDE standard
 compliance.

 If the dialog is modeless and has a parent, the default keybindings 
 (<code>escape</code> = <code>reject</code>(), <code>enter</code> = <code>accept</code>(), etc.) are disabled.

 The {@link #marginHint} and {@link #spacingHint} sizes shall be used
 whenever you layout the interior of a dialog. One special note. If
 you make your own action buttons (OK, Cancel etc), the space
 beteween the buttons shall be {@link #spacingHint}, whereas the space
 above, below, to the right and to the left shall be {@link #marginHint}.
 If you add a separator line above the buttons, there shall be a
 {@link #marginHint} between the buttons and the separator and a
 {@link #marginHint} above the separator as well.

 @author Thomas Tanghus <tanghus@earthling.net>, Espen Sand <espensa@online.no>

 @version 0.1.2

 @short 
 Dialog with extended modeless support and methods for KDE standard
 compliance.
*/
public class KDialog extends QDialog  {
	protected KDialog(Class dummy){super((Class) null);}


/** 
 Constructor. 

 Takes the same arguments as {@link QDialog}.
     
*/
	private native void newKDialog( QWidget parent, String name, boolean modal, int f);
	public KDialog( QWidget parent, String name, boolean modal, int f) {
		super((Class) null);
		newKDialog( parent, name, modal, f);
	}
	private native void newKDialog();
	public KDialog() {
		super((Class) null);
		newKDialog();
	}

/** 
 Make a KDE compliant caption.

*/
	public native void setCaption( String caption);

/** 
 Make a plain caption without any modifications.

*/
	public native void setPlainCaption( String caption);

/** 
 Return the number of pixels you shall use between a 
 dialog edge and the outermost widget(s) according to the KDE standard.

*/
	public static native int marginHint();

/** 
 Return the number of pixels you shall use between 
 widgets inside a dialog according to the KDE standard.
     
*/
	public static native int spacingHint();

/** 
 Resize every layout manager used in <code>widget</code> and its nested children.

*/
	public static native void resizeLayout( QWidget widget, int margin, int spacing);

/** 
 Reszie every layout associated with <code>lay</code> and its children. 

*/
	public static native void resizeLayout( QLayoutItemInterface lay, int margin, int spacing);
}

/** Override these methods in subclasses of KDialog to customise event handling behaviour */
interface KDialogEventHandling {

/** 

     
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

