/***************************************************************************
                            KDirWatch.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Watch directories for changes.

 It uses <code>stat</code> (2) and
 compares stored and actual changed time of directories. If
 there is a difference it notifies about the change. Directories can be
 added, removed from the list and scanning of particular directories
 can be stopped and restarted. The whole class can be stopped and
 restarted. Directories can be added/removed from list in
 any state.
 When a watched directory is changed, {@link KDirWatch} will emit
 the signal {@link #dirty}.

 If a watched directory gets deleted, {@link KDirwatch} will remove it from
 the list, and  emit the signal {@link #deleted}.

 It's possible to watch a directory that doesn't exist yet.
 {@link KDirWatch} will emit a {@link #dirty} signal when it is created.

 @author Sven Radej <sven@lisa.exp.univie.ac.at>
  
 @short Class for watching directory changes.

*/
public class KDirWatch extends QObject  {
	protected KDirWatch(Class dummy){super((Class) null);}


/** 
 Constructor.

 Does not begin scanning until {@link #startScan}
 is called. Default frequency is 500 ms.
    
*/
	private native void newKDirWatch( int freq);
	public KDirWatch( int freq) {
		super((Class) null);
		newKDirWatch( freq);
	}
	private native void newKDirWatch();
	public KDirWatch() {
		super((Class) null);
		newKDirWatch();
	}

/** 
 Destructor.

 Stops scanning and cleans up.
    
*/
	protected native void finalize() throws InternalError;

/** 
 Add a directory to the list of directories to be watched.

    
*/
	public native void addDir( String path);

/** 
 Retrieve the time the directory was last changed.
    
*/
	public native long ctime( String path);

/** 
 Remove a directory from the list of scanned directories.

 If specified path is not in the list this does nothing.
    
*/
	public native void removeDir( String path);

/** 
 Stop scanning the specified path.

 The <code>path</code> is not deleted from the interal just, it is just skipped.
 Call this function when you perform an huge operation
 on this directory (copy/move big files or many files). When finished,
 call {@link #restartDirScan}.
 Returns <code>false</code> if specified path is not in list, <code>true</code> otherwise.
    
*/
	public native boolean stopDirScan( String path);

/** 
 Restart scanning for specified path.

 Resets ctime. It doesn't notify
 the change (by emitted a signal), since the ctime value is reset.

 Call it when you are finished with big operations on that path,
 <em>and</em> when <em>you</em> have refreshed that path.  Returns <code>false</code>
 if specified path is not in list, <code>true</code> otherwise.  
    
*/
	public native boolean restartDirScan( String path);

/** 
 Start scanning of all dirs in list.

 If notify is <code>true</code>, all changed directories (since {@link #stopScan} call) will be notified for refresh. If notify is
 <code>false</code>, all ctimes will be reset (except those who are stopped,
 but only if <code>skippedToo</code> is <code>false</code>) and changed dirs won't be
 notified. You can start scanning even if the list is
 empty. First call should be called with <code>false</code> or else all 
 directories 
 in list will be notified.  If
 <code>skippedToo</code> is true, the skipped directoris (scanning of which was
 stopped with {@link #stopDirScan} ) will be reset and notified
 for change.  Otherwise, stopped directories will continue to be
 unnotified.
    
*/
	public native void startScan( boolean notify, boolean skippedToo);
	public native void startScan();

/** 
 Stop scanning of all directories in internal list.

 The timer is stopped, but the list is not cleared.
    
*/
	public native void stopScan();
	public native boolean contains( String path);

/**  {@link signal} fileDirty() 
*/
	public native void setFileDirty( String _file);
	public static native KDirWatch self();
	protected native void resetList( boolean reallyall);
	protected native void slotRescan();
	protected native void famEventReceived();
}

/** Override these methods in subclasses of KDirWatch to customise event handling behaviour */
interface KDirWatchEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

