/***************************************************************************
                            KDockWidgetHeader.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The header (additional bar) for a {@link KDockWidget} s (and member of the dockwidget class set).
 It have got the buttons located there. And it is for recording and reading the button states.
 More or less a minor helper class for the dockwidget class set.

 @author Max Judin (documentation: Falk Brettschneider).

 @version $Id: KDockWidgetHeader.java,v 1.3 2001/05/16 22:52:51 rdale Exp $
 
 @short 
 The header (additional bar) for a @ref KDockWidget s (and member of the dockwidget class set).
*/
public class KDockWidgetHeader extends KDockWidgetAbstractHeader  {
	protected KDockWidgetHeader(Class dummy){super((Class) null);}


/** 
 Constructs this.

*/
	private native void newKDockWidgetHeader( KDockWidget parent, String name);
	public KDockWidgetHeader( KDockWidget parent, String name) {
		super((Class) null);
		newKDockWidgetHeader( parent, name);
	}
	private native void newKDockWidgetHeader( KDockWidget parent);
	public KDockWidgetHeader( KDockWidget parent) {
		super((Class) null);
		newKDockWidgetHeader( parent);
	}

/** 
 Destructs this.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Hides the close button and stay button when switching to toplevel or vice versa shows them.

*/
	public native void setTopLevel( boolean t);
	public native boolean dragEnabled();
	public native void setDragEnabled( boolean b);

/** 
 Saves the current button state to a KDE config container object.

*/
	public native void saveConfig( KConfig c);

/** 
 Loads the current button state from a KDE config container object.

*/
	public native void loadConfig( KConfig arg1);

/** 
 Set dragging the dockwidget off when the stay button is pressed down and vice versa.
   
*/
	protected native void slotStayClicked();
}

/** Override these methods in subclasses of KDockWidgetHeader to customise event handling behaviour */
interface KDockWidgetHeaderEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

