/***************************************************************************
                            KDualColorButton.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDualColorButton allows the user to select two cascaded colors (usually a
 foreground and background color). Other features include drag and drop
 from other KDE color widgets, a reset to black and white control, and a
 swap colors control.

 When the user clicks on the foreground or background rectangle the
 rectangle is first sunken and the {@link #currentChanged} signal is emitted.
 Further clicks will present a color dialog and emit either the {@link #fgChanged}
 or {@link #bgChanged} if a new color is selected.

 Note: With drag and drop when dropping a color the current selected color
 will be set, while when dragging a color it will use whatever color
 rectangle the mouse was pressed inside.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A widget for selecting two related colors.

*/
public class KDualColorButton extends QWidget  {
	protected KDualColorButton(Class dummy){super((Class) null);}


/** 
 Constructs a new KDualColorButton using the default black and white
 colors.

     
*/
	private native void newKDualColorButton( QWidget parent, String name);
	public KDualColorButton( QWidget parent, String name) {
		super((Class) null);
		newKDualColorButton( parent, name);
	}
	private native void newKDualColorButton();
	public KDualColorButton() {
		super((Class) null);
		newKDualColorButton();
	}

/** 
 Constructs a new KDualColorButton using the default black and white
 colors.

 BIC: merge with the above next Wednesday, dialogParent defaults to null
     
*/
	private native void newKDualColorButton( QWidget parent, String name, QWidget dialogParent);
	public KDualColorButton( QWidget parent, String name, QWidget dialogParent) {
		super((Class) null);
		newKDualColorButton( parent, name, dialogParent);
	}

/** 
 Constructs a new KDualColorButton with the supplied foreground and
 background colors.
     
*/
	private native void newKDualColorButton( QColor fgColor, QColor bgColor, QWidget parent, String name);
	public KDualColorButton( QColor fgColor, QColor bgColor, QWidget parent, String name) {
		super((Class) null);
		newKDualColorButton( fgColor, bgColor, parent, name);
	}
	private native void newKDualColorButton( QColor fgColor, QColor bgColor);
	public KDualColorButton( QColor fgColor, QColor bgColor) {
		super((Class) null);
		newKDualColorButton( fgColor, bgColor);
	}

/** 
 Constructs a new KDualColorButton with the supplied foreground and
 background colors.

 BIC: merge with the above next Wednesday, dialogParent defaults to null
     
*/
	private native void newKDualColorButton( QColor fgColor, QColor bgColor, QWidget parent, String name, QWidget dialogParent);
	public KDualColorButton( QColor fgColor, QColor bgColor, QWidget parent, String name, QWidget dialogParent) {
		super((Class) null);
		newKDualColorButton( fgColor, bgColor, parent, name, dialogParent);
	}
	protected native void finalize() throws InternalError;

/** 
 Returns the current foreground color.
     
*/
	public native QColor foreground();

/** 
 Returns the current background color.
     
*/
	public native QColor background();

/** 
 Returns the current color item selected by the user.
     
*/
	public native int current();

/** 
 Returns the color of the selected item.
     
*/
	public native QColor currentColor();

/** 
 Returns the minimum size needed to display the widget and all its
 controls.
     
*/
	public native QSize sizeHint();

/** 
 Sets the foreground color.
     
*/
	public native void setForeground( QColor c);

/** 
 Sets the background color.
     
*/
	public native void setBackground( QColor c);

/** 
 Sets the current selected color item.
     
*/
	public native void setCurrent( int s);

/** 
 Sets the color of the selected item.
     
*/
	public native void setCurrentColor( QColor c);

/** 
 Sets the supplied rectangles to the proper size and position for the
 current widget size. You can reimplement this to change the layout
 of the widget. Restrictions are that the swap control will always
 be at the top right, the reset control will always be at the bottom
 left, and you must leave at least a 14x14 space in those corners.
     
*/
	protected native void metrics( QRect fgRect, QRect bgRect);
	public static final int Foreground = 0;
	public static final int Background = 1;
}

/** Override these methods in subclasses of KDualColorButton to customise event handling behaviour */
interface KDualColorButtonEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent ev);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent ev);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent ev);
	void dragEnterEvent(QDragEnterEvent ev);
	void mouseMoveEvent(QMouseEvent ev);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent ev);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

