/***************************************************************************
                            KFileItem.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class  KFileItem implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KFileItem(Class dummy){}


/** 
 Create an item representing a file, from an UDSEntry (see kio/global.h)
 This is the preferred constructor when using KIO.listDir().

*/
//	private native void newKFileItem( UDSEntry _entry, KURL _url, boolean _determineMimeTypeOnDemand, boolean _urlIsDirectory);
//	public KFileItem( UDSEntry _entry, KURL _url, boolean _determineMimeTypeOnDemand, boolean _urlIsDirectory) {
//		newKFileItem( _entry, _url, _determineMimeTypeOnDemand, _urlIsDirectory);
//	}
//	private native void newKFileItem( UDSEntry _entry, KURL _url);
//	public KFileItem( UDSEntry _entry, KURL _url) {
//		newKFileItem( _entry, _url);
//	}

/** 
 Create an item representing a file, from all the necessary info for it

*/
	private native void newKFileItem( long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand);
	public KFileItem( long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand) {
		newKFileItem( _mode, _permissions, _url, _determineMimeTypeOnDemand);
	}
	private native void newKFileItem( long _mode, long _permissions, KURL _url);
	public KFileItem( long _mode, long _permissions, KURL _url) {
		newKFileItem( _mode, _permissions, _url);
	}

/** 
 Create an item representing a file, for which the mimetype is already known

*/
	private native void newKFileItem( KURL url, String mimeType, long mode);
	public KFileItem( KURL url, String mimeType, long mode) {
		newKFileItem( url, mimeType, mode);
	}

/** 
 Copy constructor
   
*/
	private native void newKFileItem( KFileItem item);
	public KFileItem( KFileItem item) {
		newKFileItem( item);
	}

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;

/** 
 Re-read information (currently only permissions and mimetype)
 This is called when the _file_ changes
   
*/
	public native void refresh();

/** 
 Re-read mimetype information
 This is called when the mimetype database changes
   
*/
	public native void refreshMimeType();

/** 

*/
	public native KURL url();

/** 
 Set the item's URL. Do not call unless you know what you are doing!
 (used for example when an item got renamed)
   
*/
	public native void setURL( KURL url);

/** 

*/
	public native long permissions();

/** 

*/
	public native long mode();

/** 

*/
	public native String user();

/** 

*/
	public native String group();

/** 

*/
	public native boolean isLink();

/** 

*/
	public native boolean isDir();

/** 

*/
	public native boolean isReadable();

/** 

*/
	public native String linkDest();

/** 

*/
	public native long size();

/** 

*/
	public native long time( int which);

/** 

*/
	public native boolean isLocalFile();

/** 

*/
	public native String text();

/** 

*/
	public native String name( boolean lowerCase);

/** 

*/
	public native String mimetype();

/** 

*/
//	public native KMimeType_Ptr determineMimeType();

/** 

*/
//	public native KMimeType_Ptr mimeTypePtr();
	public native boolean isMimeTypeKnown();

/** 

*/
	public native String mimeComment();

/** 

*/
	public native String iconName();

/** 
 Returns a pixmap representing the file

*/
	public native QPixmap pixmap( int _size, int _state);
	public native QPixmap pixmap( int _size);

/** 

*/
	public native String getStatusBarInfo();

/** 

*/
	public native boolean acceptsDrops();

/** 
 Let's "KRun" this file !
 (e.g. when file is clicked or double-clicked or return is pressed)
   
*/
	public native void run();

/** 

*/
//	public native UDSEntry entry();
	public native boolean isMarked();
	public native void mark();
	public native void unmark();

/** 
 Somewhat like a comparison operator, but more explicit
   
*/
	public native boolean cmp( KFileItem item);

/** 
 Somewhat like an assignment operator, but more explicit
   
*/
	public native void assign( KFileItem item);

/** 
 Computes the text, mode, and mimetype from the UDSEntry
 Called by constructor, but can be called again later
   
*/
	protected native void init( boolean _determineMimeTypeOnDemand);
}
