/***************************************************************************
                            KFileViewItem.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides information about a file that has been created
 by KDirLister/KIO.

 @author rich@kde.org

 @version $Id: KFileViewItem.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
  
 @short 
 Provides information about a file that has been created
 by KDirLister/KIO.
*/
public class KFileViewItem extends KFileItem  {
	protected KFileViewItem(Class dummy){super((Class) null);}


/** 
 Construct a KFileViewItem
      
*/
//	private native void newKFileViewItem( KURL baseURL, UDSEntry arg1);
//	public KFileViewItem( KURL baseURL, UDSEntry arg1) {
//		super((Class) null);
//		newKFileViewItem( baseURL, arg1);
//	}

/** 
 Constructs a "little" KFileViewItem (just for local files)
      
*/
	private native void newKFileViewItem( long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand);
	public KFileViewItem( long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand) {
		super((Class) null);
		newKFileViewItem( _mode, _permissions, _url, _determineMimeTypeOnDemand);
	}

/** 
 Copy constructor. Note: you can't have an item twice in a view.
 This constructor does <em>not</em> copy any set {@link #viewItem} and
 neither does it copy the reference to the {@link #next} item.
     
*/
	private native void newKFileViewItem( KFileViewItem arg1);
	public KFileViewItem( KFileViewItem arg1) {
		super((Class) null);
		newKFileViewItem( arg1);
	}

/** 
 Destroy the KFileViewItem object.
      
*/
	protected native void finalize() throws InternalError;

/** 
 Returns true if this item represents a file (and not a a directory)
      
*/
	public native boolean isFile();
	public native String urlString();

/** 
 Returns a pixmap representing the file

*/
	public native QPixmap pixmap( int size, int state);
	public native QPixmap pixmap( int size);

/** 
 Returns a pixmap for this file. The only difference to the other
 pixmap() method is that the last used Pixmap-size will be used.
 E.g. if you call pixmap( KIcon.SizeSmall ) once, you can refer to
 this pixmap thru this method without specifying the size.
 The default size is KIcon.SizeSmall. Use 0 for the default size.
     
*/
	public native QPixmap pixmap();

/** 
 Returns a string of the date of the file.
      
*/
	public native String date();

/** 
 Returns the access permissions for the file as a string.
      
*/
	public native String access();
	public native void setViewItem( KFileViewInterface view, int item);
	public native int viewItem( KFileViewInterface view);
	public native KFileViewItem next();
	public native void setNext( KFileViewItem n);
	public static native String dateTime( long secsSince1Jan1970UTC);
	protected native String parsePermissions( long perm);
}
