/***************************************************************************
                            KFontChooser.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A widget for interactive font selection.

 While {@link KFontChooser} as an ordinary widget can be embedded in
 custom dialogs and therefore is very flexible, in most cases
 it is preferable to use the convenience functions in
 {@link KFontDialog}.

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontChooser.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short A font selection widget.

*/
public class KFontChooser extends QWidget  {
	protected KFontChooser(Class dummy){super((Class) null);}


/** 
 Constructs a font picker widget.

*/
	private native void newKFontChooser( QWidget parent, String name, boolean onlyFixed, String[] arg1, boolean makeFrame, int visibleListSize);
	public KFontChooser( QWidget parent, String name, boolean onlyFixed, String[] arg1, boolean makeFrame, int visibleListSize) {
		super((Class) null);
		newKFontChooser( parent, name, onlyFixed, arg1, makeFrame, visibleListSize);
	}
	private native void newKFontChooser();
	public KFontChooser() {
		super((Class) null);
		newKFontChooser();
	}

/** 
 Enable or disable a font column in the chooser.

 Use this
 function if your application does not need or supports all font
 properties.

*/
	public native void enableColumn( int column, boolean state);

/** 
 Set the currently selected font in the chooser.

*/
	public native void setFont( QFont font, boolean onlyFixed);
	public native void setFont( QFont font);

/** 

*/
	public native QFont font();

/** 
 Set the currently selected charset in the chooser.
   
*/
	public native void setCharset( String charset);

/** 

*/
	public native String charset();

/** 

*/
	public native String sampleText();

/** 
 Set the sample text.

 Normally you should not change this
 text, but it can be better to do this if the default text is
 too large for the edit area when using the default font of your
 application.

*/
	public native void setSampleText( String text);

/** 
 Reimplemented for internal reasons.
   
*/
	public native QSize sizeHint();

/** 
 Convert a {@link QFont} into the corresponding X Logical Font
 Description (XLFD).

*/
	public static native String getXLFD( QFont theFont);

/** 
 Create a list of font strings that match <code>pattern.</code>

*/
	public static native void getFontList( String[] list, String pattern);

/** 
 Create a list of font strings.

*/
	public static native void getFontList( String[] list, boolean fixed);
	public static final int FamilyList = 0x01;
	public static final int StyleList = 0x02;
	public static final int SizeList = 0x04;
	public static final int CharsetList = 0x08;
}

/** Override these methods in subclasses of KFontChooser to customise event handling behaviour */
interface KFontChooserEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

