/***************************************************************************
                            KFontDialog.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KFontDialog provides a dialog for interactive font selection.
 It is basically a thin wrapper around the {@link KFontChooser} widget,
 which can also be used standalone. In most cases, the simplest
 use of this class is the static method {@link KFontDialog#getFont},
 which pops up the dialog, allows the user to select a font, and
 returns when the dialog is closed.

 Example:

 <pre>
      QFont myFont;
      int result = KFontDialog.getFont( myFont );
      if ( result == KFontDialog.Accepted )
            ...
 </pre>

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontDialog.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short A font selection dialog.

*/
public class KFontDialog extends KDialogBase  {
	protected KFontDialog(Class dummy){super((Class) null);}


/** 
 Constructs a font selection dialog.

   
*/
	private native void newKFontDialog( QWidget parent, String name, boolean onlyFixed, boolean modal, String[] arg1, boolean makeFrame);
	public KFontDialog( QWidget parent, String name, boolean onlyFixed, boolean modal, String[] arg1, boolean makeFrame) {
		super((Class) null);
		newKFontDialog( parent, name, onlyFixed, modal, arg1, makeFrame);
	}
	private native void newKFontDialog();
	public KFontDialog() {
		super((Class) null);
		newKFontDialog();
	}

/** 
 Sets the currently selected font in the dialog.

*/
	public native void setFont( QFont font, boolean onlyFixed);
	public native void setFont( QFont font);

/** 

*/
	public native QFont font();

/** 
 Sets the currently selected charset in the dialog.
   
*/
	public native void setCharset( String charset);

/** 

*/
	public native String charset();

/** 
 Creates a modal font dialog, lets the user choose a font,
 and returns when the dialog is closed.

*/
	public static native int getFont( QFont theFont, boolean onlyFixed, QWidget parent, boolean makeFrame);
	public static native int getFont( QFont theFont);

/** 
 When you are not only interested in the font selected, but also
 in the example string typed in, you can call this method.

*/
	public static native int getFontAndText( QFont theFont, String theString, boolean onlyFixed, QWidget parent, boolean makeFrame);
	public static native int getFontAndText( QFont theFont, String theString);
}

/** Override these methods in subclasses of KFontDialog to customise event handling behaviour */
interface KFontDialogEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

