/***************************************************************************
                            KGlobalSettings.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access the KDE global configuration.

 @author David Faure <faure@kde.org>

 @version $Id: KGlobalSettings.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short 
 Access the KDE global configuration.
*/
public class  KGlobalSettings implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KGlobalSettings(Class dummy){}


/** 
 Returns a treshold in pixels for drag & drop operations.
 As long as the mouse movement has not exceeded this number
 of pixels in either X or Y direction no drag operation may
 be started. This prevents spurious drags when the user intended
 to click on something but moved the mouse a bit while doing so.

 For this to work you must save the position of the mouse (<code>oldPos</code>)
 in the {@link QWidget#mousePressEvent}.
 When the position of the mouse (<code>newPos</code>)
 in a  {@link QWidget#mouseMoveEvent} exceeds this treshold
 you may start a drag
 which should originate from {@link oldPos}.

 Example code:
 <pre>
 void KColorCells.mousePressEvent( QMouseEvent e )
 {
    mOldPos = e.pos();
 }

 void KColorCells.mouseMoveEvent( QMouseEvent e )
 {
    if( !(e.state() && LeftButton)) return;

    int delay = KGlobalSettings.dndEventDelay();
    QPoint newPos = e.pos();
    if(newPos.x() > mOldPos.x()+delay || newPos.x() < mOldPos.x()-delay ||
       newPos.y() > mOldPos.y()+delay || newPos.y() < mOldPos.y()-delay)
    {
       // Drag color object
       int cell = posToCell(mOldPos); // Find color at mOldPos
       if ((cell != -1) && colors[cell].isValid())
       {
          KColorDrag d = KColorDrag.makeDrag( colors[cell], this);
          d.dragCopy();
       }
    }
 }
 </pre>

     
*/
	public static native int dndEventDelay();

/** 
 Returns whether KDE runs in single (default) or double click
 mode.

 see {@link http}://developer.kde.org/documentation/standards/kde/style/mouse/index.html

*/
	public static native boolean singleClick();

/** 
 Returns whether tear-off handles are inserted in KPopupMenus.

*/
	public static native boolean insertTearOffHandle();

/** 

*/
	public static native boolean changeCursorOverIcon();

/** 

*/
	public static native boolean visualActivate();
	public static native int visualActivateSpeed();

/** 
 Returns the KDE setting for the auto-select option

*/
	public static native int autoSelectDelay();

/** 
 Returns the KDE setting for the shortcut key to open
 context menus.

*/
	public static native int contextMenuKey();

/** 
 Returns the KDE setting for context menus.

*/
	public static native boolean showContextMenusOnPress();
	public static native int completionMode();

/** 
 This returns whether or not KDE should use certain GNOME
 resources.  The resources, in this case, are things like pixmap
 directories, applnk paths, etc.

*/
	public static native boolean honorGnome();

/** 
 This returns the current mouse settings.
     
*/
//	public static native KMouseSettings& mouseSettings();

/** 
 The path to the desktop directory of the current user.
     
*/
	public static native String desktopPath();

/** 
 The path to the autostart directory of the current user.
     
*/
	public static native String autostartPath();

/** 
 The path to the trash directory of the current user.
     
*/
	public static native String trashPath();

/** 
 The path where documents are stored of the current user.
     
*/
	public static native String documentPath();

/** 
 The default color to use when highlighting toolbar buttons
     
*/
	public static native QColor toolBarHighlightColor();
	public static native QColor inactiveTitleColor();
	public static native QColor inactiveTextColor();
	public static native QColor activeTitleColor();
	public static native QColor activeTextColor();
	public static native int contrast();

/** 
 The default colors to use for text and links.
     
*/
	public static native QColor baseColor();
	public static native QColor textColor();
	public static native QColor linkColor();
	public static native QColor visitedLinkColor();
	public static native QColor highlightedTextColor();
	public static native QColor highlightColor();
	public static native QFont generalFont();
	public static native QFont fixedFont();
	public static native QFont toolBarFont();
	public static native QFont menuFont();
	public static final int CompletionNone = 1;
	public static final int CompletionAuto = 0;
	public static final int CompletionMan = 1;
	public static final int CompletionShell = 2;
	public static final int CompletionPopup = 3;
}
