/***************************************************************************
                            KGradientSelector.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
 
 @short 
 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
*/
public class KGradientSelector extends KSelector  {
	protected KGradientSelector(Class dummy){super((Class) null);}


/** 
 Constructs a horizontal color selector which
 contains a gradient between white and black.
   
*/
	private native void newKGradientSelector( QWidget parent, String name);
	public KGradientSelector( QWidget parent, String name) {
		super((Class) null);
		newKGradientSelector( parent, name);
	}
	private native void newKGradientSelector();
	public KGradientSelector() {
		super((Class) null);
		newKGradientSelector();
	}

/** 
 Constructs a colors selector with orientation o which
 contains a gradient between white and black.
   
*/
	private native void newKGradientSelector( int o, QWidget parent, String name);
	public KGradientSelector( int o, QWidget parent, String name) {
		super((Class) null);
		newKGradientSelector( o, parent, name);
	}
	private native void newKGradientSelector( int o);
	public KGradientSelector( int o) {
		super((Class) null);
		newKGradientSelector( o);
	}

/** 
 Destructs the widget.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Sets the two colors which span the gradient.
   
*/
	public native void setColors( QColor col1, QColor col2);
	public native void setText( String t1, String t2);

}

/** Override these methods in subclasses of KGradientSelector to customise event handling behaviour */
interface KGradientSelectorEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);

/** 

   
*/
	void mousePressEvent(QMouseEvent e);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);

/** 

   
*/
	void mouseMoveEvent(QMouseEvent e);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);

/** 

   
*/
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

