/***************************************************************************
                            KHTMLPart.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is khtml's main class. It features an almost complete
 web browser, and html renderer.

 The easiest way to use this class (if you just want to display a an HTML
 page at some URL) is the following:

 <pre>
 KURL url = "http://www.kde.org";
 KHTMLPart w = new KHTMLPart();
 w.openURL(url);
 w.view().resize(500, 400);
 w.show();
 </pre>

 By default Java and JavaScript support are disabled. You can enable them by
 using the {@link #enableJava} and {@link #enableJScript} methods.

 Some apps want to write their HTML code directly into the widget instead of
 it opening an url. You can also do that in the following way:

 <pre>
 String myHTMLCode = ...;
 KHTMLPart w = new KHTMLPart();
 w.begin();
 w.write(myHTMLCode);
 ...
 w.end();
 </pre>

 You can do as many calls to write as you want. But there are two
 {@link #write} methods, one accepting a {@link String} one accepting a
 <code>char</code> <code>argument.</code> You should use one or the other
 (but not both) since the method using
 the <code>char</code> <code>argument</code> does an additional decoding step to convert the
 written data to Unicode.

 @author Lars Knoll (knoll@kde.org)

 @version $Id: KHTMLPart.java,v 1.3 2001/05/16 22:52:51 rdale Exp $
 
 @short HTML Browser Widget.
*/
public class KHTMLPart extends ReadOnlyPart  {
	protected KHTMLPart(Class dummy){super((Class) null);}


/** 
 Construct a new {@link KHTMLPart}.

 KHTML basically consists of two objects: The {@link KHTMLPart} itself,
 holding the document data (DOM document), and the {@link KHTMLView},
 derived from {@link QScrollview}, in which the document content is
 rendered in. You can specify two different parent objects for a
 {@link KHTMLPart}, one parent for the {@link KHTMLPart} document and on parent
 for the {@link KHTMLView}. If the second <code>parent</code> argument is null, then
 <code>parentWidget</code> is used as parent for both objects, the part and
 the view.
   
*/
	private native void newKHTMLPart( QWidget parentWidget, String widgetname, QObject parent, String name, int prof);
	public KHTMLPart( QWidget parentWidget, String widgetname, QObject parent, String name, int prof) {
		super((Class) null);
		newKHTMLPart( parentWidget, widgetname, parent, name, prof);
	}
	private native void newKHTMLPart();
	public KHTMLPart() {
		super((Class) null);
		newKHTMLPart();
	}
	private native void newKHTMLPart( KHTMLView view, QObject parent, String name, int prof);
	public KHTMLPart( KHTMLView view, QObject parent, String name, int prof) {
		super((Class) null);
		newKHTMLPart( view, parent, name, prof);
	}
	private native void newKHTMLPart( KHTMLView view);
	public KHTMLPart( KHTMLView view) {
		super((Class) null);
		newKHTMLPart( view);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Opens the specified URL <code>url.</code>

 Reimplemented from {@link KParts#ReadOnlyPart}.openURL .
   
*/
	public native boolean openURL( KURL url);

/** 
 Stop loading the document and kill all data requests (for images, etc.)
   
*/
	public native boolean closeURL();

/** 
 Retrieve a reference to the DOM HTML document (for non-HTML documents, returns null)
   
*/
	public native HTMLDocument htmlDocument();

/** 
 Retrieve a reference to the DOM document.
   
*/
	public native DOMDocument document();

/** 
 Retrieve the node that has the keyboard focus
   
*/
	public native DOMNode activeNode();

/** 
 Retrieve a pointer to the {@link KParts#BrowserExtension}
   
*/
	public native BrowserExtension browserExtension();

/** 
 Retrieve a pointer to the HTML document's view.
   
*/
	public native KHTMLView view();

/** 
 Enable/disable Javascript support. Note that this will
 in either case permanently override the default usersetting.
 If you want to have the default UserSettings, don't call this
 method.
   
*/
	public native void setJScriptEnabled( boolean enable);

/** 
 Deprecated, use setJScriptEnabled instead.
   
*/
	public native void enableJScript( boolean enable);

/** 
 Returns <code>true</code> if Javascript support is enabled or <code>false</code>
 otherwise.
   
*/
	public native boolean jScriptEnabled();

/** 
 Enable/disable the automatic forwarding by <meta http-equiv="refresh" ....>
   
*/
	public native void enableMetaRefresh( boolean enable);

/** 
 Returns <code>true</code> if automtaic forwarding is enabled.
   
*/
	public native boolean metaRefreshEnabled();

/** 
 Execute the specified snippet of JavaScript code.

 Returns <code>true</code> if JavaScript was enabled, no error occured
 and the code returned true itself or <code>false</code> otherwise.

   
*/
	public native QVariant executeScript( String script);

/** 
 Same as above except the Node parameter specifying the 'this' value.
   
*/
	public native QVariant executeScript( DOMNode n, String script);

/** 
 Enable or disable Drag'n'Drop support. A drag operation is started if
 the users drags a link.
   
*/
	public native void setDNDEnabled( boolean b);

/** 
 Returns whether Dragn'n'Drop support is enabled or not.
   
*/
	public native boolean dndEnabled();

/** 
 Enable/disable Java applet support. Note that calling this function
 will permanently override the User settings about Java applet support.
 Not calling this function is the only way to let the default settings
 apply.
   
*/
	public native void setJavaEnabled( boolean enable);

/** 
 Deprecated, use setJavaEnabled instead.
   
*/
	public native void enableJava( boolean enable);

/** 
 Return if Java applet support is enabled/disabled.
   
*/
	public native boolean javaEnabled();

/** 
 Return the java context of the applets. If no applet exists, 0 is returned.
   
*/
	public native KJavaAppletContext javaContext();

/** 
 Return the java context of the applets. If no context exists yet, a new one is
 created.
   
*/
	public native KJavaAppletContext createJavaContext();

/** 
 Deprecated. Use setPluginsEnabled instead.
   
*/
	public native void enablePlugins( boolean enable);

/** 
 Enable or disable plugins via, default is enabled
   
*/
	public native void setPluginsEnabled( boolean enable);

/** 
 Return if plugins are enabled/disabled.
   
*/
	public native boolean pluginsEnabled();

/** 
 Deprecated. Use setAutoloadImages instead.
   
*/
	public native void autoloadImages( boolean enable);

/** 
 Specify whether images contained in the document should be loaded
 automatically or not.

 @note Request will be ignored if called before {@link #begin}.
   
*/
	public native void setAutoloadImages( boolean enable);

/** 
 Return whether images contained in the document are loaded automatically
 or not.
 @note that the returned information is unrelieable as long as no begin()
 was called.
   
*/
	public native boolean autoloadImages();

/** 
 Security option

 Specify whether only local references ( stylesheets, images, scripts, subdocuments )
 should be loaded. ( default false - everything is loaded, if the more specific
 options allow )
   
*/
	public native void setOnlyLocalReferences( boolean enable);

/** 
 Return whether references should be loaded ( default false )

*/
	public native boolean onlyLocalReferences();

/** 
 Clear the widget and prepares it for new content.

 If you want {@link #url} to return
 for example "file:/tmp/test.html", you can use the following code:
 <PRE>
 view.begin( KURL("file:/tmp/test.html" ) );
 </PRE>

 All child frames and the old document are removed if you call
 this method.
   
*/
	public native void begin( KURL arg1, int xOffset, int yOffset);
	public native void begin();

/** 
 Write another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.

 The HTML code is send through a decoder which decodes the stream to
 Unicode.

 The <code>len</code> parameter is needed for streams encoded in utf-16,
 since these can have \0 chars in them. In case the encoding
 you're using isn't utf-16, you can safely leave out the length
 parameter.

 Attention: Don't mix calls to {@link #write} with calls
 to {@link #write}.

 The result might not be what you want.
   
*/
	public native void write( String str, int len);
	public native void write( String str);


/** 
 Call this after your last call to {@link #write}.
   
*/
	public native void end();

/** 
 Paints the HTML page to a QPainter. See {@link KHTMLView#paint} for details
   
*/
	public native void paint( QPainter arg1, QRect arg2, int arg3, int[] arg4);
	public native void paint( QPainter arg1, QRect arg2);
	public native void setBaseURL( KURL url);

/** 
 Retrieve the base URL of this document

 The base URL is ususally set by a <base url=...>
 tag in the document head. If no base tag is set, the url of the current
 document serves as base url and is returned.
   
*/
	public native KURL baseURL();

/** 
 Mainly used internally.

Sets the document's base target.
   
*/
	public native void setBaseTarget( String target);

/** 
 Retrieve the base target of this document.

 The base target is ususally set by a <base target=...>
 tag in the document head.
   
*/
	public native String baseTarget();

/** 
 Constructs a KURL object (representing an absolute URL) given a possibly
 relative URL (for example from a document's anchor) .
   
*/
	public native KURL completeURL( String url, String target);
	public native KURL completeURL( String url);

/** 

   
*/
	public native void scheduleRedirection( int delay, String url);

/** 
 Set the charset to use for displaying HTML pages.

 If override is <code>true</code>,
 it will override charset specifications of the document.
   
*/
	public native boolean setCharset( String name, boolean override);
	public native boolean setCharset( String name);

/** 
 Set the encoding the page uses.

 This can be different from the charset. The widget will try to reload the current page in the new
 encoding, if url() is not empty.
   
*/
	public native boolean setEncoding( String name, boolean override);
	public native boolean setEncoding( String name);

/** 
 return the encoding the page currently uses.

 Note that the encoding might be different from the charset.
   
*/
	public native String encoding();

/** 
 Set a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
	public native void setUserStyleSheet( KURL url);

/** 
 Set a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
	public native void setUserStyleSheet( String styleSheet);

/** 
 Reset the point sizes to be associated with the HTML-sizes used in
 <FONT size=Html-Font-Size> to their default.

 Html-Font-Sizes range from 0 (smallest) to 6 (biggest).
   
*/
	public native void resetFontSizes();

/** 
 Set the standard font style.

*/
	public native void setStandardFont( String name);

/** 
 Set the fixed font style.

*/
	public native void setFixedFont( String name);

/** 
 Find the anchor named <code>name.</code>

 If the anchor is found, the widget
 scrolls to the closest position. Returns <code>if</code> the anchor has
 been found.
   
*/
	public native boolean gotoAnchor( String name);

/** 
 Set the cursor to use when the cursor is on a link.
   
*/
	public native void setURLCursor( QCursor c);

/** 
 Retrieve the cursor which is used when the cursor is on a link.
   
*/
	public native QCursor urlCursor();

/** 
 Initiate a text search.
   
*/
	public native void findTextBegin();

/** 
 Find the next occurrance of the expression.
   
*/
//	public native boolean findTextNext( QRegExp exp, boolean forward);

/** 
 Find the next occurence of the string.
   
*/
	public native boolean findTextNext( String str, boolean forward, boolean caseSensitive);

/** 
 Get the text the user has marked.
   
*/
	public native String selectedText();

/** 
 Retrieve the selected part of the HTML.
   
*/
//	public native DOM_Range selection();

/** 
 set the current selection
   
*/
	public native void setSelection( int arg1);

/** 
 Has the user selected anything?

  Call {@link #selectedText} to
 retrieve the selected text.

*/
	public native boolean hasSelection();

/** 
 Marks all text in the document as selected.
   
*/
	public native void selectAll();

/** 
 Convenience method to show the document's view.

 Equivalent to widget().show() or view().show() .
   
*/
	public native void show();

/** 
 Convenience method to hide the document's view.

 Equivalent to widget().hide() or view().hide().
   
*/
	public native void hide();

/** 
 Retrieve a reference to the partmanager instance which
 manages html frame objects.
   
*/
	public native PartManager partManager();

/** 
 Save the {@link KHTMLPart}'s complete state (including child frame
 objects) to the provided {@link QDataStream}.

 This is called from the {@link #saveState} method of the
  {@link #browserExtension}.
   
*/
	public native void saveState( QDataStream stream);

/** 
 Restore the {@link KHTMLPart}'s previously saved state (including
 child frame objects) from the provided QDataStream.

 This is called from the {@link #restoreState} method of the
 {@link #browserExtension} .

*/
	public native void restoreState( QDataStream stream);

/** 
 Internal method called by restoreState() when the document, which is to
 be restored, is contained in the html page-cache.
   
*/
	public native boolean restoreURL( KURL url);

/** 
 Retrieve the <code>Node</code> currently under the mouse
   
*/
	public native DOMNode nodeUnderMouse();

/** 

   
*/
	public native KHTMLSettings settings();

/** 
 Retrieve a pointer to the parent {@link KHTMLPart} if the part is a frame
 in an HTML frameset.

  Returns null otherwise.
   
*/
	public native KHTMLPart parentPart();

/** 
 Retrieve a list of names of all frame (including iframe) objects of
 the current document. Note that this method is not working recursively
 for sub-frames.
   
*/
	public native ArrayList frameNames();

/** 
 Find a frame by name. Returns null if frame can't be found.
   
*/
	public native KHTMLPart findFrame( String f);

/** 
 Returns whether a frame with the specified name is exists or not.
 In contrary to the {@link findFrame} method this one also returns true
 if the frame is defined but no displaying component has been
 found/loaded, yet.
   
*/
	public native boolean frameExists( String frameName);

/** 
 The real implementation of the openURLInFrame method of
 KParts.BrowserExtension, called by khtml's implementation
 of the BrowserExtension interface.
   
*/
	public native boolean openURLInFrame( KURL url, URLArgs urlArgs);

/** 
 Called by KJS.
 Sets the StatusBarText assigned
 via window.status
   
*/
	public native void setJSStatusBarText( String text);

/** 
 Called by KJS.
 Sets the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
	public native void setJSDefaultStatusBarText( String text);

/** 
 Called by KJS.
 Returns the StatusBarText assigned
 via window.status
   
*/
	public native String jsStatusBarText();

/** 
 Called by KJS.
 Returns the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
	public native String jsDefaultStatusBarText();

/** 
 Call this method to explicitly pass the focus to a certain element of the
 current document.
   
*/
	public native void setActiveNode( DOMNode arg1);

/** 
 Stops all animated images on the current and child pages
   
*/
	public native void stopAnimations();

/** 
 Reimplementation of KParts.ReadOnlyPart.event .
   
*/
	public native boolean event( QEvent event);

/** 
 Reimplementation of QObject.eventFilter .
   
*/
	public native boolean eventFilter( QObject o, QEvent event);

/** 
 Internal empty reimplementation of {@link KParts#ReadOnlyPart}.openFile .
   
*/
	protected native boolean openFile();

/** 

   
*/
	protected native void overURL( String url, String target);

/** 

   
*/
	protected native void urlSelected( String url, int button, int state, String _target);
	protected native void urlSelected( String url);

/** 

   
*/
//	protected native boolean processObjectRequest( khtml_ChildFrame child, KURL url, String mimetype);

/** 

   
*/
	protected native void submitForm( String action, String url, byte[] formData, String target, String contentType, String boundary);
	protected native void submitForm( String action, String url, byte[] formData, String target);

/** 

   
*/
	protected native void popupMenu( String url);

/** 
 This method is called when a new embedded object (include html frames) is to be created.
 Reimplement it if you want to add support for certain embeddable objects without registering
 them in the KDE wide registry system (KSyCoCa) . Another reason for re-implementing this
 method could be if you want to derive from KTHMLPart and also want all html frame objects
 to be a object of your derived type, in which case you should return a new instance for
 the mimetype 'text/html' .
   
*/
	protected native ReadOnlyPart createPart( QWidget parentWidget, String widgetName, QObject parent, String name, String mimetype, String serviceName, String[] serviceTypes, String[] params);

/** 

   
*/
	protected native void updateFontSize( int add);

/** 

   
*/
	protected native void setFontBaseInternal( int base, boolean absolute);
	protected native void emitSelectionChanged();

/** 
 Internal. Called by the {@link BrowserExtension} .
   
*/
	protected native void reparseConfiguration();
	public static final int DefaultGUI = 0;
	public static final int BrowserViewGUI = 1;
}

/** Override these methods in subclasses of KHTMLPart to customise event handling behaviour */
interface KHTMLPartEventHandling {

/** 
 Eventhandler for the khtml.MouseDoubleClickEvent.
   
*/
	void khtmlMouseMoveEvent(MouseMoveEvent event);

/**
 Convenience method which is called when the Part received a {@link PartActivateEvent} .
 Reimplement this if you don't want to reimplement {@link event} and test for the event yourself
 or even install an event filter.

*/
	void partActivateEvent(PartActivateEvent event);

/**
 Convenience method which is called when the Part received a
 {@link PartSelectEvent} .
 Reimplement this if you don't want to reimplement {@link event} and
 test for the event yourself or even install an event filter.

*/
	void partSelectEvent(PartSelectEvent event);
	void childEvent(QChildEvent arg1);

/**
 Internal reimplementation of KParts.Part.guiActivateEvent .

*/
	void guiActivateEvent(GUIActivateEvent event);

/**
 Eventhandler of the khtml.MousePressEvent.

*/
	void khtmlMousePressEvent(MousePressEvent event);

/**
 Eventhandler for the khtml.MouseMoveEvent.

*/
	void khtmlMouseReleaseEvent(MouseReleaseEvent event);

/**
 Eventhandler for the khtml.MouseDoubleClickEvent.

*/
	void khtmlMouseDoubleClickEvent(MouseDoubleClickEvent arg1);
	void timerEvent(QTimerEvent arg1);

/**
 Eventhandler for the khtml.DrawContentsEvent.

*/
	void khtmlDrawContentsEvent(DrawContentsEvent arg1);
}

