/***************************************************************************
                            KHelpMenu.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class provides the standard KDE help menu with the default "about"
 dialog boxes and help entry.

 This class is used in {@link KMainWindow} so
 normally you don't need to use this class yourself. However, if you
 need the help menu or any of its dialog boxes in your code that is
 not subclassed from {@link KMainWindow} you should use this class.

 The usage is simple:

 <pre>
 mHelpMenu = new KHelpMenu( this, <someText> );
 kmenubar.insertItem(i18n("&Help"), mHelpMenu.menu() );
 </pre>

 or if you just want to open a dialog box:

 <pre>
 mHelpMenu = new KHelpMenu( this, <someText> );
 connect( this, SIGNAL("someSignal()"), mHelpMenu,SLOT("mHelpMenu.aboutKDE()"));
 </pre>

 IMPORTANT:
 The first time you use mHelpMenu.menu(), a {@link KPopupMenu} object is
 allocated. Only one object is created by the class so if you call
 {@link mHelpMenu#menu} twice or more, the same pointer is returned. The class
 will destroy the popupmenu in the destructor so do not delete this
 pointer yourself.

 The {@link KHelpMenu} object will be deleted when its parent is destroyed but you
 can delete it yourself if you want. The code below will always work.

 <pre>
 MyClass.~MyClass()
 {
   delete mHelpMenu;
 }
 </pre>

 Using your own "about application" dialog box:

 The standard "about application" dialog box is quite simple. If you
 need a dialog box with more functionality you must design that one
 yourself. When you want to display the dialog you can choose one of
 two methods. Common for both is that you must make a help menu object
 with no text argument If the text is missing the default dialog box
 will not be displayed:

 Example 1 Using {@link showAboutApplication} signal (preferred)
 <pre>

 void MyClass.myFunc()
 {
   ..
   KHelpMenu helpMenu = new KHelpMenu( this );
   connect( helpMenu, SIGNAL("showAboutApplication()"),
          this, SLOT("myDialogSlot()"));
   ..
 }

 void MyClass.myDialogSlot()
 {
   <activate your custom dialog>
 }
 </pre>

 Example 2 Old style - connecting directly to the menu entry.
 <pre>

 void MyClass.myFunc()
 {
   KHelpMenu helpMenu = new KHelpMenu( this );
   KPopupMenu help = mHelpMenu.menu();
   help.connectItem( KHelpMenu.menuAboutApp, this, SLOT("myDialogSlot()") );
 }

 void MyClass.myDialogSlot()
 {
   <activate your custom dialog>
 }
 </pre>

 @author Espen Sand (espen@kde.org)

 @version $Id: KHelpMenu.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short Standard KDE help menu with dialog boxes.

*/
public class KHelpMenu extends QObject  {
	protected KHelpMenu(Class dummy){super((Class) null);}


/** 
 Constructor.

     
*/
	private native void newKHelpMenu( QWidget parent, String aboutAppText, boolean showWhatsThis);
	public KHelpMenu( QWidget parent, String aboutAppText, boolean showWhatsThis) {
		super((Class) null);
		newKHelpMenu( parent, aboutAppText, showWhatsThis);
	}
	private native void newKHelpMenu();
	public KHelpMenu() {
		super((Class) null);
		newKHelpMenu();
	}

/** 
 Constructor.

     
*/
	private native void newKHelpMenu( QWidget parent, KAboutData aboutData, boolean showWhatsThis, KActionCollection actions);
	public KHelpMenu( QWidget parent, KAboutData aboutData, boolean showWhatsThis, KActionCollection actions) {
		super((Class) null);
		newKHelpMenu( parent, aboutData, showWhatsThis, actions);
	}
	private native void newKHelpMenu( QWidget parent, KAboutData aboutData);
	public KHelpMenu( QWidget parent, KAboutData aboutData) {
		super((Class) null);
		newKHelpMenu( parent, aboutData);
	}

/** 
 Destructor

 Destroys dialogs and the menu pointer retuned by {@link menu}
     
*/
	protected native void finalize() throws InternalError;

/** 
 Returns a popup menu you can use in the menu bar or where you
 need it.

 Note: This method will only create one instance of the menu. If
 you call this method twice or more the same pointer is returned
     
*/
	public native KPopupMenu menu();

/** 
 Opens the help page for the application. The application name is
 used as a key to determine what to display and the system will attempt
 to open <appName>/index.html.
     
*/
	public native void appHelpActivated();

/** 
 Activates What's This help for the application.
     
*/
	public native void contextHelpActivated();

/** 
 Opens an application specific dialog box. The dialog box will display
 the string that was defined in the constructor. If that string was
 empty the {@link #showAboutApplication} is emitted instead.
     
*/
	public native void aboutApplication();

/** 
 Opens the standard "About KDE" dialog box.
     
*/
	public native void aboutKDE();

/** 
 Opens the standard "Report Bugs" dialog box.
     
*/
	public native void reportBug();
	public static final int menuHelpContents = 0;
	public static final int menuWhatsThis = 1;
	public static final int menuAboutApp = 2;
	public static final int menuAboutKDE = 3;
	public static final int menuReportBug = 4;
}

/** Override these methods in subclasses of KHelpMenu to customise event handling behaviour */
interface KHelpMenuEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

