/***************************************************************************
                            KIconButton.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A pushbutton for choosing an icon. Pressing on the button will open a
 KIconDialog for the user to select an icon. The current icon will be
 displayed on the button.
 
 @short 
 A pushbutton for choosing an icon.
*/
public class KIconButton extends QPushButton  {
	protected KIconButton(Class dummy){super((Class) null);}


/**  Creates a new KIconButton. Uses the global iconloader. 
*/
	private native void newKIconButton( QWidget parent, String name);
	public KIconButton( QWidget parent, String name) {
		super((Class) null);
		newKIconButton( parent, name);
	}
	private native void newKIconButton();
	public KIconButton() {
		super((Class) null);
		newKIconButton();
	}

/**  Alternate constructor for use with a different iconloader. 
*/
	private native void newKIconButton( KIconLoader loader, QWidget parent, String name);
	public KIconButton( KIconLoader loader, QWidget parent, String name) {
		super((Class) null);
		newKIconButton( loader, parent, name);
	}
	private native void newKIconButton( KIconLoader loader, QWidget parent);
	public KIconButton( KIconLoader loader, QWidget parent) {
		super((Class) null);
		newKIconButton( loader, parent);
	}
	protected native void finalize() throws InternalError;

/** 
 Set a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in setIconType are allowed,
 and only icons of that size will be shown in the icon dialog.
     
*/
	public native void setStrictIconSize( boolean b);

/** 
 Set the icon group and context. Use KIcon.NoGroup if you want to
 allow icons for any group in the given context.
     
*/
	public native void setIconType( int group, int context, boolean user);
	public native void setIconType( int group, int context);

/**  Set the button's initial icon. 
*/
	public native void setIcon( String icon);

/**  Reset the icon (reverts to an empty button) 
*/
	public native void resetIcon();

/**  Returns the selected icon name. 
*/
	public native String iconName();
}

/** Override these methods in subclasses of KIconButton to customise event handling behaviour */
interface KIconButtonEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

