/***************************************************************************
                            KIconView.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This Widget extends the functionality of QIconView to honor the system
 wide settings for Single Click/Double Click mode, Auto Selection and
 Change Cursor over Link.

 There is a new signal executed(). It gets connected to either
 {@link QIconView#clicked} or {@link QIconView#doubleClicked} depending on the KDE
 wide Single Click/Double Click settings. It is strongly recomended that
 you use this signal instead of the above mentioned. This way you dont
 need to care about the current settings.
 If you want to get informed when the user selects something connect to the
 {@link QIconView#selectionChanged} signal.

 @short A variant of QIconView that honors KDE's system-wide settings.

*/
public class KIconView extends QIconView  {
	protected KIconView(Class dummy){super((Class) null);}

	private native void newKIconView( QWidget parent, String name, int f);
	public KIconView( QWidget parent, String name, int f) {
		super((Class) null);
		newKIconView( parent, name, f);
	}
	private native void newKIconView();
	public KIconView() {
		super((Class) null);
		newKIconView();
	}
	protected native void finalize() throws InternalError;

/** 
 Sets the mode to Execute or Select.

 Default is Execute.
   
*/
	public native void setMode( int m);

/** 

*/
	public native int mode();

/** 
 Returns the index of <code>item</code> or -1 if <code>item</code> doesn't exist
 in this icon view.
   
*/
	public native int itemIndex( QIconViewItem item);
	protected native void emitExecute( QIconViewItem item, QPoint pos);
	protected native void slotOnItem( QIconViewItem item);
	protected native void slotOnViewport();
	protected native void slotSettingsChanged( int arg1);

/** 
 Auto selection happend.
   
*/
	protected native void slotAutoSelect();
	public static final int Execute = 0;
	public static final int Select = 1;
}

/** Override these methods in subclasses of KIconView to customise event handling behaviour */
interface KIconViewEventHandling {
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent fe);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);
	void leaveEvent(QEvent e);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent e);
	void contentsDropEvent(QDropEvent e);
	void focusInEvent(QFocusEvent e);
	void contentsDragLeaveEvent(QDragLeaveEvent e);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);
	void contentsMouseDoubleClickEvent(QMouseEvent e);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent e);
	void moveEvent(QMoveEvent arg1);
	void contentsMouseReleaseEvent(QMouseEvent e);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent e);
	void contentsMouseMoveEvent(QMouseEvent e);
	void contentsMousePressEvent(QMouseEvent e);
	void closeEvent(QCloseEvent arg1);
	void viewportPaintEvent(QPaintEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent e);
}

