/***************************************************************************
                            KInstance.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access to KDE global objects for use in shared libraries.  In
 practical terms, this class is used in KDE components.  This allows
 components to store things that normally would be accessed by
 {@link KGlobal}.

 @author Torben Weis

 @version $Id: KInstance.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short 
 Access to KDE global objects for use in shared libraries.
*/
public class  KInstance implements QtSupport, KInstanceInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KInstance(Class dummy){}


/** 
  Constructor

*/
	private native void newKInstance( String instanceName);
	public KInstance( String instanceName) {
		newKInstance( instanceName);
	}

/** 
  Constructor

  When building a KInstance that is not your KApplication,
  make sure that the KAboutData and the KInstance have the same life time.
  You have to destroy both, since the instance doesn't own the about data.
  Don't build a KAboutData on the stack in this case !
  Building a KAboutData on the stack is only ok for usage with
  KCmdLineArgs and KApplication (not destroyed until the app exits).
     
*/
	private native void newKInstance( KAboutData aboutData);
	public KInstance( KAboutData aboutData) {
		newKInstance( aboutData);
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
  Retrieve the application standard dirs object.
     
*/
	public native KStandardDirs dirs();

/** 
  Retrieve the general config object.
     
*/
	public native KConfig config();

/** 
  Retrieve an iconloader object.
     
*/
	public native KIconLoader iconLoader();

/** 
 Re-allocate the global iconloader.
     
*/
	public native void newIconLoader();
	public native KCharsets charsets();

/** 

*/
	public native KAboutData aboutData();

/** 

*/
	public native String instanceName();

/** 

 Mainly added for API completeness and future extensibility.
     
*/
//	public native KMimeSourceFactory mimeSourceFactory();

/** 
  Copy Constructor is not allowed
     
*/
	private native void newKInstance( KInstanceInterface arg1);
	public KInstance( KInstanceInterface arg1) {
		newKInstance( arg1);
	}
}
