/***************************************************************************
                            KIntSpinBox.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  An integer inputline with scrollbar and slider.

  The class provides an easy interface to use other
  numeric systems then the decimal.

 @short A spin box widget for non-decimal numbers.
 
*/
public class KIntSpinBox extends QSpinBox  {
	protected KIntSpinBox(Class dummy){super((Class) null);}


/** 
  Constructor.

  Constructs a widget with an integer inputline with a little scrollbar
  and a slider, with minimal value 0, maximal value 99, step 1, base 10
  and initial value 0.
     
*/
	private native void newKIntSpinBox( QWidget parent, String name);
	public KIntSpinBox( QWidget parent, String name) {
		super((Class) null);
		newKIntSpinBox( parent, name);
	}
	private native void newKIntSpinBox();
	public KIntSpinBox() {
		super((Class) null);
		newKIntSpinBox();
	}

/** 
  Constructor.

  Constructs a widget with an integer inputline with a little scrollbar
  and a slider.

*/
	private native void newKIntSpinBox( int lower, int upper, int step, int value, int base, QWidget parent, String name);
	public KIntSpinBox( int lower, int upper, int step, int value, int base, QWidget parent, String name) {
		super((Class) null);
		newKIntSpinBox( lower, upper, step, value, base, parent, name);
	}
	private native void newKIntSpinBox( int lower, int upper, int step, int value);
	public KIntSpinBox( int lower, int upper, int step, int value) {
		super((Class) null);
		newKIntSpinBox( lower, upper, step, value);
	}

/** 
  Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
  Reimplemented for internal reasons; the API is not affected. 
     
*/
	public native int value();

/** 
 Sets the base in which the numbers in the spin box are represented.
     
*/
	public native void setBase( int base);

/** 

*/
	public native int base();

/** 
 sets focus and optionally marks all text

     
*/
	public native void setEditFocus( boolean mark);

/** 
  Overloaded to make use of the base given in the constructor.
     
*/
	protected native String mapValueToText( int arg1);

/** 
  Overloaded to make use of the base given in the constructor.
     
*/
	protected native int mapTextToValue( int[] arg1);
}

/** Override these methods in subclasses of KIntSpinBox to customise event handling behaviour */
interface KIntSpinBoxEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);

/** 

     
*/
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent ev);
}

