/***************************************************************************
                            KKeyChooser.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Configure dictionaries of key/action associations for KAccel and
 KGlobalAccel.

 The class takes care of all aspects of configuration, including
 handling key conflicts internally. Connect to the {@link #allDefault}
 slot if you want to set all configurable keybindings to their
 default values.

 
 @author Nicolas Hadacek <hadacek@via.ecp.fr>

 @version $Id: KKeyChooser.java,v 1.3 2001/05/16 22:52:51 rdale Exp $

 @short Widget for configuration of @ref KAccel and @ref KGlobalAccel.

*/
public class KKeyChooser extends QWidget  {
	protected KKeyChooser(Class dummy){super((Class) null);}


/** 
 Constructor.

*/
//	private native void newKKeyChooser( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys);
//	public KKeyChooser( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys) {
//		super((Class) null);
//		newKKeyChooser( aKeyDict, parent, check_against_std_keys);
//	}
//	private native void newKKeyChooser( KKeyEntryMap aKeyDict);
//	public KKeyChooser( KKeyEntryMap aKeyDict) {
//		super((Class) null);
//		newKKeyChooser( aKeyDict);
//	}
//	protected native void finalize() throws InternalError;

/** 
 Set all keys to their default values (bindings).

*/
	public native void allDefault();

/** 
 Set all list entries to their changed values.
 Use this if you changed the underlying map

*/
	public native void listSync();
	public native boolean event( QEvent e);
	protected native void fontChange( QFont _font);
	protected native boolean isKeyPresent( int kcode, boolean warnuser);
	protected native boolean isKeyPresent( int kcode);
	protected native void setKey( int kCode);
	protected native void toChange( QListViewItem item);
	protected native void changeKey();
	protected native void updateAction( QListViewItem item);
	protected native void defaultKey();
	protected native void noKey();
	protected native void keyMode( int _mode);
	protected native void shiftClicked();
	protected native void ctrlClicked();
	protected native void altClicked();
	protected native void editKey();
	protected native void editEnd();
	protected native void readGlobalKeys();
	protected native void readStdKeys();
	public static final int NoKey = 1;
	public static final int DefaultKey = 0;
	public static final int CustomKey = 1;
}

/** Override these methods in subclasses of KKeyChooser to customise event handling behaviour */
interface KKeyChooserEventHandling {
	void keyPressEvent(QKeyEvent _event);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

