/***************************************************************************
                            KKeyDialog.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KAccel and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Two static methods are supplied which provide the most convienient interface
 to the dialog. For example you could use KAccel and KKeyDialog like this

 <pre>
 KAccel keys;

 keys.insertItem( i18n( "Zoom in" ), "Zoom in", "+" );
 keys.connectItem( "Zoom in", myWindow, SLOT(" zoomIn()") );

 keys.connectItem( KAccel.Print, myWindow, SLOT(" print()") );

 keys.readSettings();

 if( KKeyDialog.configureKeys( &keys ) ) {
	      ...
 }
 </pre>

 This will also implicitly save the settings. If you don't want this,
 you can call

 <pre>
 if( KKeyDialog.configureKeys( &keys, false ) ) { // do not save settings
	      ...
 }
 </pre>

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyDialog.java,v 1.3 2001/05/16 22:52:51 rdale Exp $

 @short Dialog for configuration of @ref KAccel and @ref KGlobalAccel.

*/
public class KKeyDialog extends KDialogBase  {
	protected KKeyDialog(Class dummy){super((Class) null);}

//	private native void newKKeyDialog( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys);
//	public KKeyDialog( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys) {
//		super((Class) null);
//		newKKeyDialog( aKeyDict, parent, check_against_std_keys);
//	}
//	private native void newKKeyDialog( KKeyEntryMap aKeyDict);
//	public KKeyDialog( KKeyEntryMap aKeyDict) {
//		super((Class) null);
//		newKKeyDialog( aKeyDict);
//	}
//	protected native void finalize() throws InternalError;

/** 
 Configure key settings.

*/
	public static native int configureKeys( KAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KAccel keys);

/** 
 Configure key settings.

*/
	public static native int configureKeys( KGlobalAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KGlobalAccel keys);

/** 
 Configure key settings.

*/
	public static native int configureKeys( KActionCollection coll, String xmlfile, boolean save_settings, QWidget parent);
	public static native int configureKeys( KActionCollection coll, String xmlfile);
}

/** Override these methods in subclasses of KKeyDialog to customise event handling behaviour */
interface KKeyDialogEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

