/***************************************************************************
                            KListView.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This Widget extends the functionality of QListView to honor the system
 wide settings for Single Click/Double Click mode, AutoSelection and
 ChangeCursorOverLink (TM).

 There is a new signal executed(). It gets connected to either
 {@link QListView#clicked} or  {@link QListView#doubleClicked} depending on the KDE
 wide Single Click/Double Click settings. It is strongly recommended that
 you use this signal instead of the above mentioned. This way you dont
 need to care about the current settings.
 If you want to get informed when the user selects something connect to the
 QListView.selectionChanged() signal.

 Drag-and-Drop is supported with the signal {@link #dropped}, just {@link #setAcceptDrops}(true)
 and connect it to a suitable slot.
 To see where you are dropping, {@link #setDropVisualizer}.
 And also you'll need {@link #acceptDrag}

 KListView is drag-enabled, too: to benefit from that you've got derive from it.
 Reimplement {@link #dragObject} and (possibly) {@link #startDrag},
 and {@link #setDragEnabled}.

 @version $Id: KListView.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short 
 This Widget extends the functionality of QListView to honor the system
 wide settings for Single Click/Double Click mode, AutoSelection and
 ChangeCursorOverLink (TM).
*/
public class KListView extends QListView  {
	protected KListView(Class dummy){super((Class) null);}


/** 
 Constructor.

 The parameters <code>parent</code> and <code>name</code> are handled by
 {@link QListView}, as usual.
   
*/
	private native void newKListView( QWidget parent, String name);
	public KListView( QWidget parent, String name) {
		super((Class) null);
		newKListView( parent, name);
	}
	private native void newKListView();
	public KListView() {
		super((Class) null);
		newKListView();
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	public native void setAcceptDrops( boolean arg1);

/** 
 This function determines whether the given coordinates are within the
 execute area. The execute area is the part of a {@link QListViewItem} where mouse
 clicks or double clicks respectively generate a {@link #executed} signal.
 Depending on {@link QListView#allColumnsShowFocus} this is either the
 whole item or only the first column.

*/
	public native boolean isExecuteArea( QPoint point);

/** 
 Same thing, but from an x coordinate only. This only checks if x is in
 the first column (if all columns don't show focus), without testing if
 the y coordinate is over an item or not.
   
*/
	public native boolean isExecuteArea( int x);

/** 
 Arbitrarily move <code>item</code> to <code>parent</code>, positioned immediately after item <code>after.</code>
   
*/
	public native void moveItem( QListViewItem item, QListViewItem parent, QListViewItem after);

/** 

*/
	public native QListViewItem lastItem();

/** 

*/
	public native QListViewItem lastChild();

/** 

*/
	public native boolean itemsMovable();

/** 

*/
	public native boolean itemsRenameable();

/** 

*/
	public native boolean dragEnabled();

/** 

*/
	public native boolean autoOpen();

/** 

*/
	public native boolean isRenameable( int column);

/** 

*/
	public native boolean dropVisualizer();

/** 

*/
	public native int tooltipColumn();

/** 
 For future expansions.

 Do not use.

   
*/
	public native boolean createChildren();

/** 
 For future expansions.

 Do not use.

   
*/
	public native boolean dropHighlighter();

/** 
 The dropVisualizerWidth defaults to 4.

*/
	public native int dropVisualizerWidth();

/** 

*/
	public native int selectionModeExt();

/** 
 Returns the index of <code>item</code> within the item tree or -1 if
 <code>item</code> doesn't exist in this list view. This function takes
 all items into account not only the visible ones.
   
*/
	public native int itemIndex( QListViewItem item);

/** 
 Returns the item of <code>index</code> within the item tree or 0 if
 <code>index</code> doesn't exist in this list view. This function takes
 all items into account not only the visible ones.
   
*/
	public native QListViewItem itemAtIndex( int index);

/** 
 Rename column <code>c</code> of <code>item.</code>
   
*/
	public native void rename( QListViewItem item, int c);

/** 
 By default, if you called setItemsRenameable(true),
 only the first column is renameable.
 Use this function to enable the feature on other columns.

 If you want more intelligent (dynamic) selection,
 you'll have to derive from KListView,
 and override {@link #rename} and call only call it
 if you want the item to be renamed.

*/
	public native void setRenameable( int column, boolean yesno);
	public native void setRenameable( int column);

/** 
 Set whether items in the list view can be moved.
 It is enabled by default.

*/
	public native void setItemsMovable( boolean b);

/** 
 Enables inplace-renaming of items.
 It is disabled by default.

*/
	public native void setItemsRenameable( boolean b);

/** 
 Enable/Disable the dragging of items.
 It is disabled by default.
   
*/
	public native void setDragEnabled( boolean b);

/** 
 Enable/Disable AutoOpen (not implemented currently).
   
*/
	public native void setAutoOpen( boolean b);

/** 
 Enable/Disable the drawing of a drop-visualizer
 (a bar that shows where a dropped item would be inserted).
 It is enabled by default, if dragging is enabled
   
*/
	public native void setDropVisualizer( boolean b);

/** 
 Set the width of the (default) drop-visualizer.
 If you don't call this method, the width is set to 4.
   
*/
	public native void setDropVisualizerWidth( int w);

/** 
 Set which column should be used for automatic tooltips.

*/
	public native void setTooltipColumn( int column);

/** 
 For future expansion.

 Do not use.

   
*/
	public native void setDropHighlighter( boolean b);

/** 
 For future expansions.

 Do not use.

   
*/
	public native void setCreateChildren( boolean b);

/** 
 Set the selection mode.

 A different name was chosen to avoid API-clashes with {@link QListView#setSelectionMode}.
   
*/
	public native void setSelectionModeExt( int mode);

/** 
 Determine whether a drop on position <code>p</code> would count as
 being above or below the QRect <code>rect.</code>

*/
	protected native boolean below( QRect rect, QPoint p);

/** 
 An overloaded version of below(const QRect&, const QPoint&).

 It differs from the above only in what arguments it takes.

*/
	protected native boolean below( QListViewItem i, QPoint p);

/** 
 Emit signal {@link execute}.

   
*/
	protected native void emitExecute( QListViewItem item, QPoint pos, int c);

/** 

*/
	protected native String tooltip( QListViewItem item, int column);

/** 

*/
	protected native boolean showTooltip( QListViewItem item, QPoint pos, int column);

/** 

 A common mistake is to forget the "const" in your reimplementation

*/
	protected native QDragObject dragObject();

/** 

*/
	protected native boolean acceptDrag( QDropEvent event);

/** 
 Paint the drag line. If painter is null, don't try to :)

 If after == 0 then the marker should be drawn at the top.

*/
	protected native QRect drawDropVisualizer( QPainter p, QListViewItem parent, QListViewItem after);

/** 
 For future expansion.

 Do not use.

 Highlight <code>item.</code>  painter may be null
 return the rect drawn to

   
*/
	protected native QRect drawItemHighlighter( QPainter painter, QListViewItem item);

/** 
 This method calls {@link #dragObject} and starts the drag.

 Reimplement it to do fancy stuff like setting a pixmap or
 using a non-default DragMode
   
*/
	protected native void startDrag();

/** 
 Only called by konq_listviewwidget to select the current item
 after listing. For more information look in konquerorKeyPressEvent().
   
*/
	protected native void selectCurrentItemAndEnableSelectedBySimpleMoveMode();

/** 
 Where is the nearest QListViewItem that I'm going to drop?
 ### for 3.0 : make this virtual
   
*/
//	protected native void findDrop( QPoint pos, QListViewItem** parent, QListViewItem** after);

/** 
 Convert the depth of an item into its indentation in pixels
   
*/
	protected native int depthToPixels( int depth);

/** 
 Update internal settings whenever the global ones change.

   
*/
	protected native void slotSettingsChanged( int arg1);
	protected native void slotMouseButtonClicked( int btn, QListViewItem item, QPoint pos, int c);
	protected native void doneEditing( QListViewItem item, int row);

/** 
 Repaint the rect where I was drawing the drop line.
   
*/
	protected native void cleanDropVisualizer();

/** 
 For future expansion.

 Do not use.

   
*/
	protected native void cleanItemHighlighter();

/** 
 Emit the {@link contextMenu} signal. This slot is for mouse actions.
   
*/
	protected native void emitContextMenu( QListViewItem arg1, QPoint arg2, int arg3);

/** 
 Emit the {@link contextMenu} signal. This slot is for key presses.
   
*/
	protected native void emitContextMenu( KListView arg1, QListViewItem arg2);

/** 
 Accessory slot for AutoSelect

   
*/
	protected native void slotOnItem( QListViewItem item);

/** 
 Accessory slot for AutoSelect/ChangeCursorOverItem

   
*/
	protected native void slotOnViewport();

/** 
 Process AutoSelection.

   
*/
	protected native void slotAutoSelect();
	public static final int Single = QListView.Single;
	public static final int Multi = QListView.Multi;
	public static final int Extended = QListView.Extended;
	public static final int NoSelection = QListView.NoSelection;
	public static final int Konqueror = 0;
}

/** Override these methods in subclasses of KListView to customise event handling behaviour */
interface KListViewEventHandling {

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void focusOutEvent(QFocusEvent fe);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void leaveEvent(QEvent e);
	void showEvent(QShowEvent arg1);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);

/** 
 A special keyPressEvent (for Konqueror-style selection).
   
*/
	void konquerorKeyPressEvent(QKeyEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsDropEvent(QDropEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void focusInEvent(QFocusEvent fe);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsDragLeaveEvent(QDragLeaveEvent event);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMouseDoubleClickEvent(QMouseEvent e);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsDragMoveEvent(QDragMoveEvent event);
	void moveEvent(QMoveEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMouseReleaseEvent(QMouseEvent arg1);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsDragEnterEvent(QDragEnterEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMouseMoveEvent(QMouseEvent e);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMousePressEvent(QMouseEvent e);
	void closeEvent(QCloseEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void viewportPaintEvent(QPaintEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent e);
}

