/***************************************************************************
                            KMenuBar.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDE Style-able menubar.

 This is required since {@link QMenuBar} is currently not handled by
 {@link QStyle}.

 @author Daniel "Mosfet" Duley.

 @version $Id: KMenuBar.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short 
 KDE Style-able menubar.
*/
public class KMenuBar extends QMenuBar  {
	protected KMenuBar(Class dummy){super((Class) null);}

	private native void newKMenuBar( QWidget parent, String name);
	public KMenuBar( QWidget parent, String name) {
		super((Class) null);
		newKMenuBar( parent, name);
	}
	private native void newKMenuBar();
	public KMenuBar() {
		super((Class) null);
		newKMenuBar();
	}
	protected native void finalize() throws InternalError;

/** 
 This controls whether or not this menubar will be a top-level
 bar similar to the way Macintosh handles menubars.  This
 overrides any global config settings.

 Keep in mind that it is probably a really bad idea to use this
 unless you really know what you're doing.  A feature like a
 top-level menubar is one that should really be shared by all
 applications.  If your app is the only one with a top-level
 bar, then things might look very... odd.

 This is included only for those people that <code>do</code> know that
 they need to use it.

*/
	public native void setTopLevelMenu( boolean top_level);
	public native void setTopLevelMenu();

/** 
 Is our menubar a top-level (Macintosh style) menubar?

*/
	public native boolean isTopLevelMenu();
	public native void show();
	protected native void drawContents( QPainter p);
	public native boolean eventFilter( QObject arg1, QEvent arg2);
	protected native void slotReadConfig();
}

/** Override these methods in subclasses of KMenuBar to customise event handling behaviour */
interface KMenuBarEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent ev);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent ev);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

