/***************************************************************************
                            KMidSimpleAPI.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Simple API covering most of the uses of libkmid.

 You can use the members of this class in pure C applications, just by using
 the same name as the corresponding function member. 

 Suppose you're developing a game and you want to play some background music
 while the user is playing. You only have to call :

 When the user decides to quit the game, use 

 to stop the music and release the memory allocated by libkmid.

 @author Antonio Larrosa Jimenez <larrosa@kde.org> 
 
 @version 0.9.5 17/01/2000

 @short A very simple API around the rest of libkmid.

*/
public class  KMidSimpleAPI implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KMidSimpleAPI(Class dummy){}


/** 
 Initializes libkmid. Creates the DeviceManager object, and initializes
 some variables that will be used later.

*/
	public static native int kMidInit();

/** 
 Loads a song that will be played with the next call to {@link #kMidPlay}.
     
*/
	public static native int kMidLoad( String filename);

/** 
 Plays the song currently loaded with {@link #kMidLoad}.
 kMidPlay forks in order to play the song in a different process, it
 exits inmediately, so that the application can follow the normal
 execution flow while the sone is played.

 If loop is 0 the song is played once and then the child process
 finishes. If loop is 1, the song is played repeatedly until
 {@link #kMidStop} is called. You can call {@link #kMidStop} anytime you want
 (also if loop is 0) to stop the song and kill the child process.

*/
	public static native int kMidPlay( int loop);
	public static native int kMidPlay();

/** 
 Stops playing a song inmediatly. It doesn't return until the child
 process that is playing the song is terminated.

*/
	public static native int kMidStop();

/** 
 Releases the memory allocated by libkmid. To continue playing, you must
 first make a(nother) call to {@link #kMidInit}.
     
*/
	public static native void kMidDestruct();

/** 
 Returns 1 if the library is playing a song, and 0 if it's not.

*/
	public static native int kMidIsPlaying();

/** 
 Returns the number of MIDI devices  ( MIDI ports + synthesizers )

*/
	public static native int kMidDevices();

/** 
 Returns the name of the i-th device . In case libkmid wasn't yet
 initialized ( see {@link #kMidInit} ), the return value is NULL, and in
 case the parameter has a value out of the valid range 
 ( see {@link #kMidDevices} ) it returns an empty string.

*/
	public static native String kMidName( int i);

/** 
 Returns the type of the i-th device . In case libkmid wasn't yet
 initialized ( see {@link #kMidInit} ), the return value is NULL, and in
 case the parameter has a value out of the valid range 
 ( see {@link #kMidDevices} ) it returns an empty string.

*/
	public static native String kMidType( int i);

/** 
 Sets the MIDI device to use when playing a song.

*/
	public static native void kMidSetDevice( int i);

/** 
 Sets the Midi Mapper to use. Most of the users won't need a midi mapper,
 but there're still non-General Midi synthesizers out there, and people
 with one of those will get much better sound quality by using a MIDI
 mapper. 

 Please have a look at KMid's documentation for more information
 about MIDI mappers and how to write a MIDI mapper for your keyboard.
     
*/
	public static native void kMidSetMidiMapper( String mapfilename);

/** 
 Returns the version number of libkmid, i.e. "0.9.5" or "1.0 Beta"
     
*/
	public static native String kMidVersion();

/** 
 Returns the copyright notice that applications using libkmid should print
 to the user in an about box or somewhere visible.
 I.e. 

 "LibKMid 0.9.5 (C) 1997-2000 Antonio Larrosa Jimenez <larrosa@kde.org>. Spain"
     
*/
	public static native String kMidCopyright();
}
